/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.component.azure.eventhubs.EventHubsConsumer;
import org.apache.camel.component.azure.eventhubs.EventHubsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.5.0", scheme="azure-eventhubs", title="Azure Event Hubs", syntax="azure-eventhubs:namespace/eventHubName", category={Category.CLOUD, Category.MESSAGING})
public class EventHubsEndpoint
extends DefaultEndpoint {
    @UriParam
    private EventHubsConfiguration configuration;

    public EventHubsEndpoint(String uri, Component component, EventHubsConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new EventHubsProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        EventHubsConsumer eventHubConsumer = new EventHubsConsumer(this, processor);
        this.configureConsumer((Consumer)eventHubConsumer);
        return eventHubConsumer;
    }

    public EventHubsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EventHubsConfiguration configuration) {
        this.configuration = configuration;
    }
}

