/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs.client;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.util.ObjectHelper;

public final class EventHubsClientFactory {
    private static final String SERVICE_URI_SEGMENT = "servicebus.windows.net";
    private static final String BLOB_SERVICE_URI_SEGMENT = ".blob.core.windows.net";

    private EventHubsClientFactory() {
    }

    public static EventHubProducerAsyncClient createEventHubProducerAsyncClient(EventHubsConfiguration configuration) {
        return new EventHubClientBuilder().connectionString(EventHubsClientFactory.buildConnectionString(configuration)).transportType(configuration.getAmqpTransportType()).retryOptions(configuration.getAmqpRetryOptions()).buildAsyncProducerClient();
    }

    public static EventHubConsumerAsyncClient createEventHubConsumerAsyncClient(EventHubsConfiguration configuration) {
        return new EventHubClientBuilder().connectionString(EventHubsClientFactory.buildConnectionString(configuration)).consumerGroup(configuration.getConsumerGroupName()).prefetchCount(configuration.getPrefetchCount()).transportType(configuration.getAmqpTransportType()).retryOptions(configuration.getAmqpRetryOptions()).buildAsyncConsumerClient();
    }

    public static EventProcessorClient createEventProcessorClient(EventHubsConfiguration configuration, Consumer<EventContext> processEvent, Consumer<ErrorContext> processError) {
        return new EventProcessorClientBuilder().initialPartitionEventPosition(configuration.getEventPosition()).connectionString(EventHubsClientFactory.buildConnectionString(configuration)).checkpointStore(EventHubsClientFactory.createCheckpointStore(configuration)).consumerGroup(configuration.getConsumerGroupName()).retryOptions(configuration.getAmqpRetryOptions()).transportType(configuration.getAmqpTransportType()).processError(processError).processEvent(processEvent).buildEventProcessorClient();
    }

    public static BlobContainerAsyncClient createBlobContainerClient(EventHubsConfiguration configuration) {
        return new BlobContainerClientBuilder().endpoint(EventHubsClientFactory.buildAzureEndpointUri(configuration)).containerName(configuration.getBlobContainerName()).credential(EventHubsClientFactory.getCredentialForClient(configuration)).buildAsyncClient();
    }

    private static CheckpointStore createCheckpointStore(EventHubsConfiguration configuration) {
        if (ObjectHelper.isNotEmpty((Object)configuration.getCheckpointStore())) {
            return configuration.getCheckpointStore();
        }
        if (ObjectHelper.isEmpty((Object)configuration.getBlobContainerName()) || !EventHubsClientFactory.isCredentialsSet(configuration)) {
            throw new IllegalArgumentException("Since there is no provided CheckpointStore, you will need to set blobAccountName, blobAccessName or blobContainerName in order to use the default BlobCheckpointStore");
        }
        return new BlobCheckpointStore(EventHubsClientFactory.createBlobContainerClient(configuration));
    }

    private static boolean isCredentialsSet(EventHubsConfiguration configuration) {
        if (ObjectHelper.isNotEmpty((Object)configuration.getBlobStorageSharedKeyCredential())) {
            return true;
        }
        return ObjectHelper.isNotEmpty((Object)configuration.getBlobAccessKey()) && ObjectHelper.isNotEmpty((Object)configuration.getBlobAccountName());
    }

    private static String buildConnectionString(EventHubsConfiguration configuration) {
        if (ObjectHelper.isNotEmpty((Object)configuration.getConnectionString())) {
            return configuration.getConnectionString();
        }
        return String.format(Locale.ROOT, "Endpoint=sb://%s.%s/;SharedAccessKeyName=%s;SharedAccessKey=%s;EntityPath=%s", configuration.getNamespace(), SERVICE_URI_SEGMENT, configuration.getSharedAccessName(), configuration.getSharedAccessKey(), configuration.getEventHubName());
    }

    private static String buildAzureEndpointUri(EventHubsConfiguration configuration) {
        return String.format(Locale.ROOT, "https://%s.blob.core.windows.net", EventHubsClientFactory.getAccountName(configuration));
    }

    private static StorageSharedKeyCredential getCredentialForClient(EventHubsConfiguration configuration) {
        StorageSharedKeyCredential storageSharedKeyCredential = configuration.getBlobStorageSharedKeyCredential();
        if (storageSharedKeyCredential != null) {
            return storageSharedKeyCredential;
        }
        return new StorageSharedKeyCredential(configuration.getBlobAccountName(), configuration.getBlobAccessKey());
    }

    private static String getAccountName(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((Object)configuration.getBlobStorageSharedKeyCredential()) ? configuration.getBlobStorageSharedKeyCredential().getAccountName() : configuration.getBlobAccountName();
    }
}

