/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import org.apache.camel.spi.Metadata;

public final class EventHubsConstants {
    private static final String HEADER_PREFIX = "CamelAzureEventHubs";
    @Metadata(description="(producer) Overrides the hashing key to be provided for the batch of events, which instructs the Event Hubs service to map this key to a specific partition.\n(consumer) It sets the partition hashing key if it was set when originally publishing the event. If it exists, this value was used to compute a hash to select a partition to send the message to. This is only present on a received `EventData`.", javaType="String")
    public static final String PARTITION_KEY = "CamelAzureEventHubsPartitionKey";
    @Metadata(description="(producer) Overrides the identifier of the Event Hub partition that the events will be sent to.\n(consumer) It sets the partition id of the Event Hub.", javaType="String")
    public static final String PARTITION_ID = "CamelAzureEventHubsPartitionId";
    @Metadata(label="consumer", description="It sets the offset of the event when it was received from the associated Event Hub partition. This is only present on a received `EventData`.", javaType="Integer")
    public static final String OFFSET = "CamelAzureEventHubsOffset";
    @Metadata(label="consumer", description="It sets the instant, in UTC, of when the event was enqueued in the Event Hub partition. This is only present on a received `EventData`.", javaType="Instant")
    public static final String ENQUEUED_TIME = "CamelAzureEventHubsEnqueuedTime";
    @Metadata(label="consumer", description="It sets the sequence number assigned to the event when it was enqueued in the associated Event Hub partition. This is unique for every message received in the Event Hub partition. This is only present on a received `EventData`.", javaType="Long")
    public static final String SEQUENCE_NUMBER = "CamelAzureEventHubsSequenceNumber";
    @Metadata(label="consumer", description="The set of free-form event properties which may be used for passing metadata associated with the event with the event body during Event Hubs operations.", javaType="Map<String, Object>")
    public static final String METADATA = "CamelAzureEventHubsMetadata";
    @Metadata(label="consumer", description="The timestamp of the message", javaType="long")
    public static final String MESSAGE_TIMESTAMP = "CamelMessageTimestamp";

    private EventHubsConstants() {
    }
}

