/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.component.azure.eventhubs.EventHubsEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="azure-eventhubs")
public class EventHubsComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubsComponent.class);
    @Metadata
    private EventHubsConfiguration configuration = new EventHubsConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EventHubsConfiguration configuration = this.configuration != null ? this.configuration.copy() : new EventHubsConfiguration();
        EventHubsEndpoint endpoint = new EventHubsEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration::setProducerAsyncClient, configuration::getProducerAsyncClient, EventHubProducerAsyncClient.class);
        }
        if (this.areAzureClientsNotSet(configuration) && ObjectHelper.isEmpty((Object)configuration.getConnectionString())) {
            this.checkAndSetNamespaceAndHubName(configuration, remaining);
            this.validateConfigurations(configuration);
        }
        return endpoint;
    }

    public EventHubsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EventHubsConfiguration configuration) {
        this.configuration = configuration;
    }

    private <C> void checkAndSetRegistryClient(Consumer<C> setClientFn, Supplier<C> getClientFn, Class<C> clientType) {
        if (ObjectHelper.isEmpty(getClientFn.get())) {
            Set clients = this.getCamelContext().getRegistry().findByType(clientType);
            if (clients.size() == 1) {
                setClientFn.accept(clients.stream().findFirst().get());
            } else if (clients.size() > 1) {
                LOG.info(String.format("More than one %s instance in the registry, make sure to have only one instance", clientType.getSimpleName()));
            } else {
                LOG.info(String.format("No %s instance in the registry", clientType.getSimpleName()));
            }
        } else {
            LOG.info(String.format("%s instance is already set at endpoint level: skipping the check in the registry", clientType.getSimpleName()));
        }
    }

    private void validateConfigurations(EventHubsConfiguration configuration) {
        if (!this.isAccessKeyAndAccessNameSet(configuration)) {
            throw new IllegalArgumentException("Azure EventHubs SharedAccessName/SharedAccessKey, ConsumerAsyncClient/ProducerAsyncClient or connectionString must be specified.");
        }
    }

    private boolean isAccessKeyAndAccessNameSet(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((Object)configuration.getSharedAccessName()) && ObjectHelper.isNotEmpty((Object)configuration.getSharedAccessKey());
    }

    private boolean areAzureClientsNotSet(EventHubsConfiguration configuration) {
        return ObjectHelper.isEmpty((Object)configuration.getProducerAsyncClient());
    }

    private void checkAndSetNamespaceAndHubName(EventHubsConfiguration configuration, String remaining) {
        if (ObjectHelper.isEmpty((Object)remaining)) {
            throw new IllegalArgumentException("ConnectionString, AzureClients or Namespace and EventHub name must be set");
        }
        String[] parts = remaining.split("/");
        if (parts.length < 2) {
            throw new IllegalArgumentException("ConnectionString, AzureClients or Namespace and EventHub name must be set");
        }
        configuration.setNamespace(parts[0]);
        configuration.setEventHubName(parts[1]);
    }
}

