/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.models.ErrorContext;
import com.azure.messaging.eventhubs.models.EventContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.component.azure.eventhubs.EventHubsEndpoint;
import org.apache.camel.component.azure.eventhubs.client.EventHubsClientFactory;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubsConsumer.class);
    private EventProcessorClient processorClient;

    public EventHubsConsumer(EventHubsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.processorClient = EventHubsClientFactory.createEventProcessorClient(this.getConfiguration(), this::onEventListener, this::onErrorListener);
        this.processorClient.start();
    }

    protected void doStop() throws Exception {
        if (this.processorClient != null) {
            this.processorClient.stop();
        }
        super.doStop();
    }

    public EventHubsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public EventHubsEndpoint getEndpoint() {
        return (EventHubsEndpoint)super.getEndpoint();
    }

    private void onEventListener(final EventContext eventContext) {
        Exchange exchange = this.getEndpoint().createAzureEventHubExchange(eventContext);
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

            public void onComplete(Exchange exchange) {
                EventHubsConsumer.this.processCommit(exchange, eventContext);
            }

            public void onFailure(Exchange exchange) {
                EventHubsConsumer.this.processRollback(exchange);
            }
        });
        this.getAsyncProcessor().process(exchange, doneSync -> LOG.trace("Processing exchange [{}] done.", (Object)exchange));
    }

    private void onErrorListener(ErrorContext errorContext) {
        Exchange exchange = this.getEndpoint().createAzureEventHubExchange(errorContext);
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
    }

    private void processCommit(Exchange exchange, EventContext eventContext) {
        try {
            eventContext.updateCheckpoint();
        }
        catch (Exception ex) {
            this.getExceptionHandler().handleException("Error occurred during updating the checkpoint. This exception is ignored.", exchange, (Throwable)ex);
        }
    }

    private void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)cause);
        }
    }
}

