/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class EventHubsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":namespace/eventHubName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "azure-eventhubs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "namespace", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "eventHubName", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(23);
        props.add("blobStorageSharedKeyCredential");
        props.add("connectionString");
        props.add("autoDiscoverClient");
        props.add("prefetchCount");
        props.add("sharedAccessKey");
        props.add("sharedAccessName");
        props.add("partitionId");
        props.add("checkpointStore");
        props.add("exchangePattern");
        props.add("amqpTransportType");
        props.add("consumerGroupName");
        props.add("eventPosition");
        props.add("lazyStartProducer");
        props.add("blobAccountName");
        props.add("bridgeErrorHandler");
        props.add("producerAsyncClient");
        props.add("partitionKey");
        props.add("namespace");
        props.add("amqpRetryOptions");
        props.add("blobContainerName");
        props.add("eventHubName");
        props.add("exceptionHandler");
        props.add("blobAccessKey");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("blobStorageSharedKeyCredential");
        secretProps.add("connectionString");
        secretProps.add("sharedAccessKey");
        secretProps.add("blobAccessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

