/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.eventhubs.CredentialType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class EventHubsConfiguration
implements Cloneable {
    @UriPath
    private String namespace;
    @UriPath
    private String eventHubName;
    @UriParam(label="security")
    private String sharedAccessName;
    @UriParam(label="security", secret=true)
    private String sharedAccessKey;
    @UriParam(label="security", secret=true)
    private String connectionString;
    @UriParam(label="security", secret=true)
    private TokenCredential tokenCredential;
    @UriParam(label="common", defaultValue="AMQP")
    private AmqpTransportType amqpTransportType = AmqpTransportType.AMQP;
    @UriParam(label="common")
    private AmqpRetryOptions amqpRetryOptions;
    @UriParam(label="consumer", defaultValue="$Default")
    private String consumerGroupName = "$Default";
    @UriParam(label="consumer", defaultValue="500")
    private int prefetchCount = 500;
    @UriParam(label="consumer", defaultValue="BlobCheckpointStore")
    private CheckpointStore checkpointStore;
    @UriParam(label="consumer")
    private String blobAccountName;
    @UriParam(label="consumer", secret=true)
    private String blobAccessKey;
    @UriParam(label="consumer")
    private String blobContainerName;
    @UriParam(label="consumer", secret=true)
    private StorageSharedKeyCredential blobStorageSharedKeyCredential;
    @UriParam(label="consumer")
    private Map<String, EventPosition> eventPosition = new HashMap<String, EventPosition>();
    @UriParam(label="consumer", defaultValue="500")
    private int checkpointBatchSize = 500;
    @UriParam(label="consumer", defaultValue="5000")
    private int checkpointBatchTimeout = 5000;
    @UriParam(label="producer")
    @Metadata(autowired=true)
    private EventHubProducerAsyncClient producerAsyncClient;
    @UriParam(label="producer")
    private String partitionKey;
    @UriParam(label="producer")
    private String partitionId;
    @UriParam(label="security", enums="AZURE_IDENTITY,CONNECTION_STRING,TOKEN_CREDENTIAL", defaultValue="CONNECTION_STRING")
    private CredentialType credentialType = CredentialType.CONNECTION_STRING;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public void setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
    }

    public String getSharedAccessName() {
        return this.sharedAccessName;
    }

    public void setSharedAccessName(String sharedAccessName) {
        this.sharedAccessName = sharedAccessName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public void setTokenCredential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
    }

    public AmqpTransportType getAmqpTransportType() {
        return this.amqpTransportType;
    }

    public void setAmqpTransportType(AmqpTransportType amqpTransportType) {
        this.amqpTransportType = amqpTransportType;
    }

    public AmqpRetryOptions getAmqpRetryOptions() {
        return this.amqpRetryOptions;
    }

    public void setAmqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
        this.amqpRetryOptions = amqpRetryOptions;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public EventHubProducerAsyncClient getProducerAsyncClient() {
        return this.producerAsyncClient;
    }

    public void setProducerAsyncClient(EventHubProducerAsyncClient producerAsyncClient) {
        this.producerAsyncClient = producerAsyncClient;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public CheckpointStore getCheckpointStore() {
        return this.checkpointStore;
    }

    public void setCheckpointStore(CheckpointStore checkpointStore) {
        this.checkpointStore = checkpointStore;
    }

    public String getBlobAccountName() {
        return this.blobAccountName;
    }

    public void setBlobAccountName(String blobAccountName) {
        this.blobAccountName = blobAccountName;
    }

    public String getBlobAccessKey() {
        return this.blobAccessKey;
    }

    public void setBlobAccessKey(String blobAccessKey) {
        this.blobAccessKey = blobAccessKey;
    }

    public String getBlobContainerName() {
        return this.blobContainerName;
    }

    public void setBlobContainerName(String blobContainerName) {
        this.blobContainerName = blobContainerName;
    }

    public StorageSharedKeyCredential getBlobStorageSharedKeyCredential() {
        return this.blobStorageSharedKeyCredential;
    }

    public void setBlobStorageSharedKeyCredential(StorageSharedKeyCredential blobStorageSharedKeyCredential) {
        this.blobStorageSharedKeyCredential = blobStorageSharedKeyCredential;
    }

    public Map<String, EventPosition> getEventPosition() {
        return this.eventPosition;
    }

    public void setEventPosition(Map<String, EventPosition> eventPosition) {
        this.eventPosition = eventPosition;
    }

    public int getCheckpointBatchSize() {
        return this.checkpointBatchSize;
    }

    public void setCheckpointBatchSize(int checkpointBatchSize) {
        this.checkpointBatchSize = checkpointBatchSize;
    }

    public int getCheckpointBatchTimeout() {
        return this.checkpointBatchTimeout;
    }

    public void setCheckpointBatchTimeout(int checkpointBatchTimeout) {
        this.checkpointBatchTimeout = checkpointBatchTimeout;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public EventHubsConfiguration copy() {
        try {
            return (EventHubsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

