/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="azure-eventhubs:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Azure Eventhubs consumer response details")
public class EventHubsCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.azure.eventhubs.consume");
        if (message.getHeaders().containsKey("CamelAzureEventHubsPartitionId")) {
            headers.put("CamelCloudEventSource", "azure.eventhubs." + (String)message.getHeader("CamelAzureEventHubsPartitionId", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelAzureEventHubsSequenceNumber", Long.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

