/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.azure.key.vault.EventhubsReloadTriggerTask;
import org.apache.camel.component.azure.key.vault.KeyVaultPropertiesFunction;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.vault.AzureVaultConfiguration;

@DevConsole(value="azure-secrets")
public class AzureKeyVaultManagerDevConsole
extends AbstractDevConsole {
    private KeyVaultPropertiesFunction propertiesFunction;
    private EventhubsReloadTriggerTask secretsRefreshTask;

    public AzureKeyVaultManagerDevConsole() {
        super("camel", "azure-secrets", "Azure Key Vault Secrets", "Azure Key Vault Secret Manager");
    }

    protected void doStart() throws Exception {
        AzureVaultConfiguration azure;
        PropertiesFunction pf;
        super.doStart();
        if (this.getCamelContext().getPropertiesComponent().hasPropertiesFunction("azure") && (pf = this.getCamelContext().getPropertiesComponent().getPropertiesFunction("azure")) instanceof KeyVaultPropertiesFunction) {
            this.propertiesFunction = (KeyVaultPropertiesFunction)pf;
        }
        if ((azure = this.getCamelContext().getVaultConfiguration().getAzureVaultConfiguration()) != null && azure.isRefreshEnabled()) {
            PeriodTaskScheduler scheduler = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getPeriodTaskScheduler();
            this.secretsRefreshTask = (EventhubsReloadTriggerTask)scheduler.getTaskByType(EventhubsReloadTriggerTask.class);
        }
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (this.propertiesFunction != null) {
            sb.append("Azure Key Vault Secret Manager:");
            sb.append("\n    Login: Client Id/Client Secret");
            AzureVaultConfiguration azure = this.getCamelContext().getVaultConfiguration().getAzureVaultConfiguration();
            if (azure != null) {
                sb.append(String.format("\n    Refresh Enabled: %s", azure.isRefreshEnabled()));
                sb.append(String.format("\n    Refresh Period: %s", azure.getRefreshPeriod()));
            }
            if (this.secretsRefreshTask != null) {
                Instant last = this.secretsRefreshTask.getLastCheckTime();
                String s = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : "none";
                sb.append(String.format("\n    Last Check: %s", s));
                last = this.secretsRefreshTask.getLastReloadTime();
                s = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : "none";
                sb.append(String.format("\n    Last Reload: %s", s));
            }
            sb.append("\n\nSecrets in use:");
            ArrayList<String> sorted = new ArrayList<String>(this.propertiesFunction.getSecrets());
            Collections.sort(sorted);
            for (String sec : sorted) {
                String age;
                Instant last = this.secretsRefreshTask != null ? this.secretsRefreshTask.getUpdates().get(sec) : null;
                String string = age = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : null;
                if (age != null) {
                    sb.append(String.format("\n    %s (age: %s)", sec, age));
                    continue;
                }
                sb.append(String.format("\n    %s", sec));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        if (this.propertiesFunction != null) {
            root.put((Object)"login", (Object)"Client Id/Client Secret");
            AzureVaultConfiguration azure = this.getCamelContext().getVaultConfiguration().getAzureVaultConfiguration();
            if (azure != null) {
                root.put((Object)"refreshEnabled", (Object)azure.isRefreshEnabled());
                root.put((Object)"refreshPeriod", (Object)azure.getRefreshPeriod());
            }
            if (this.secretsRefreshTask != null) {
                long timestamp;
                Instant last = this.secretsRefreshTask.getLastCheckTime();
                if (last != null) {
                    timestamp = last.toEpochMilli();
                    root.put((Object)"lastCheckTimestamp", (Object)timestamp);
                    root.put((Object)"lastCheckAge", (Object)TimeUtils.printSince((long)timestamp));
                }
                if ((last = this.secretsRefreshTask.getLastReloadTime()) != null) {
                    timestamp = last.toEpochMilli();
                    root.put((Object)"lastReloadTimestamp", (Object)timestamp);
                    root.put((Object)"lastReloadAge", (Object)TimeUtils.printSince((long)timestamp));
                }
            }
            JsonArray arr = new JsonArray();
            root.put((Object)"secrets", (Object)arr);
            ArrayList<String> sorted = new ArrayList<String>(this.propertiesFunction.getSecrets());
            Collections.sort(sorted);
            for (String sec : sorted) {
                Instant last;
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)sec);
                Instant instant = last = this.secretsRefreshTask != null ? this.secretsRefreshTask.getUpdates().get(sec) : null;
                if (last != null) {
                    long timestamp = last.toEpochMilli();
                    jo.put((Object)"timestamp", (Object)timestamp);
                    jo.put((Object)"age", (Object)TimeUtils.printSince((long)timestamp));
                }
                arr.add((Object)jo);
            }
        }
        return root;
    }
}

