/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.azure.key.vault.KeyVaultConfiguration;
import org.apache.camel.component.azure.key.vault.KeyVaultEndpoint;
import org.apache.camel.component.azure.key.vault.KeyVaultOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class KeyVaultProducer
extends DefaultProducer {
    public KeyVaultProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doInit() throws Exception {
        super.doInit();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public void process(Exchange exchange) throws Exception {
        KeyVaultOperation operation = this.determineOperation(exchange);
        switch (operation) {
            case createSecret: {
                this.createSecret(exchange);
                break;
            }
            case getSecret: {
                this.getSecret(exchange);
                break;
            }
            case deleteSecret: {
                this.deleteSecret(exchange);
                break;
            }
            case purgeDeletedSecret: {
                this.purgeDeletedSecret(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createSecret(Exchange exchange) throws InvalidPayloadException {
        String secretName = (String)exchange.getMessage().getHeader("CamelAzureKeyVaultSecretName", String.class);
        if (ObjectHelper.isEmpty((String)secretName)) {
            throw new IllegalArgumentException("Secret Name must be specified for createSecret Operation");
        }
        KeyVaultSecret p = this.getEndpoint().getSecretClient().setSecret(new KeyVaultSecret(secretName, (String)exchange.getMessage().getMandatoryBody(String.class)));
        Message message = KeyVaultProducer.getMessageForResponse(exchange);
        message.setBody((Object)p);
    }

    private void getSecret(Exchange exchange) {
        String secretName = (String)exchange.getMessage().getHeader("CamelAzureKeyVaultSecretName", String.class);
        if (ObjectHelper.isEmpty((String)secretName)) {
            throw new IllegalArgumentException("Secret Name must be specified for createSecret Operation");
        }
        KeyVaultSecret p = this.getEndpoint().getSecretClient().getSecret(secretName);
        Message message = KeyVaultProducer.getMessageForResponse(exchange);
        message.setBody((Object)p.getValue());
    }

    private void deleteSecret(Exchange exchange) {
        String secretName = (String)exchange.getMessage().getHeader("CamelAzureKeyVaultSecretName", String.class);
        if (ObjectHelper.isEmpty((String)secretName)) {
            throw new IllegalArgumentException("Secret Name must be specified for createSecret Operation");
        }
        SyncPoller p = this.getEndpoint().getSecretClient().beginDeleteSecret(secretName);
        p.waitForCompletion();
        Message message = KeyVaultProducer.getMessageForResponse(exchange);
        message.setBody(p.getFinalResult());
    }

    private void purgeDeletedSecret(Exchange exchange) {
        String secretName = (String)exchange.getMessage().getHeader("CamelAzureKeyVaultSecretName", String.class);
        if (ObjectHelper.isEmpty((String)secretName)) {
            throw new IllegalArgumentException("Secret Name must be specified for createSecret Operation");
        }
        this.getEndpoint().getSecretClient().purgeDeletedSecret(secretName);
    }

    public KeyVaultEndpoint getEndpoint() {
        return (KeyVaultEndpoint)super.getEndpoint();
    }

    public KeyVaultConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private KeyVaultOperation determineOperation(Exchange exchange) {
        KeyVaultOperation operation = (KeyVaultOperation)((Object)exchange.getIn().getHeader("CamelAzureKeyVaultProducerOperation", KeyVaultOperation.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

