/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.AzureVaultConfiguration;

@PropertiesFunction(value="azure")
public class KeyVaultPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private static final String CAMEL_VAULT_AZURE_VAULT_NAME = "CAMEL_VAULT_AZURE_VAULT_NAME";
    private static final String CAMEL_VAULT_AZURE_CLIENT_ID = "CAMEL_VAULT_AZURE_CLIENT_ID";
    private static final String CAMEL_VAULT_AZURE_CLIENT_SECRET = "CAMEL_VAULT_AZURE_CLIENT_SECRET";
    private static final String CAMEL_VAULT_AZURE_TENANT_ID = "CAMEL_VAULT_AZURE_TENANT_ID";
    private CamelContext camelContext;
    private SecretClient client;
    private final Set<String> secrets = new HashSet<String>();

    protected void doStart() throws Exception {
        AzureVaultConfiguration azureVaultConfiguration;
        super.doStart();
        String vaultName = System.getenv(CAMEL_VAULT_AZURE_VAULT_NAME);
        String clientId = System.getenv(CAMEL_VAULT_AZURE_CLIENT_ID);
        String clientSecret = System.getenv(CAMEL_VAULT_AZURE_CLIENT_SECRET);
        String tenantId = System.getenv(CAMEL_VAULT_AZURE_TENANT_ID);
        if (ObjectHelper.isEmpty((String)vaultName) && ObjectHelper.isEmpty((String)clientId) && ObjectHelper.isEmpty((String)clientSecret) && ObjectHelper.isEmpty((String)tenantId) && ObjectHelper.isNotEmpty((Object)(azureVaultConfiguration = this.getCamelContext().getVaultConfiguration().azure()))) {
            vaultName = azureVaultConfiguration.getVaultName();
            clientId = azureVaultConfiguration.getClientId();
            clientSecret = azureVaultConfiguration.getClientSecret();
            tenantId = azureVaultConfiguration.getTenantId();
        }
        if (!(ObjectHelper.isNotEmpty((String)vaultName) && ObjectHelper.isNotEmpty((String)clientId) && ObjectHelper.isNotEmpty((String)clientSecret) && ObjectHelper.isNotEmpty((String)tenantId))) {
            throw new RuntimeCamelException("Using the Azure Key Vault Properties Function requires setting Azure credentials as application properties or environment variables");
        }
        String keyVaultUri = "https://" + vaultName + ".vault.azure.net";
        ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(tenantId)).clientId(clientId)).clientSecret(clientSecret).build();
        this.client = new SecretClientBuilder().vaultUrl(keyVaultUri).credential((TokenCredential)credential).buildClient();
    }

    protected void doStop() throws Exception {
        this.secrets.clear();
        super.doStop();
    }

    public String getName() {
        return "azure";
    }

    public String apply(String remainder) {
        String key = remainder;
        String subkey = null;
        String returnValue = null;
        String defaultValue = null;
        String version = null;
        if (remainder.contains("/")) {
            key = StringHelper.before((String)remainder, (String)"/");
            subkey = StringHelper.after((String)remainder, (String)"/");
            defaultValue = StringHelper.after((String)subkey, (String)":");
            if (ObjectHelper.isNotEmpty((String)defaultValue) && defaultValue.contains("@")) {
                version = StringHelper.after((String)defaultValue, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
            if (subkey.contains(":")) {
                subkey = StringHelper.before((String)subkey, (String)":");
            }
            if (subkey.contains("@")) {
                version = StringHelper.after((String)subkey, (String)"@");
                subkey = StringHelper.before((String)subkey, (String)"@");
            }
        } else if (remainder.contains(":")) {
            key = StringHelper.before((String)remainder, (String)":");
            defaultValue = StringHelper.after((String)remainder, (String)":");
            if (remainder.contains("@")) {
                version = StringHelper.after((String)remainder, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
        } else if (remainder.contains("@")) {
            key = StringHelper.before((String)remainder, (String)"@");
            version = StringHelper.after((String)remainder, (String)"@");
        }
        if (key != null) {
            try {
                returnValue = this.getSecretFromSource(key, subkey, defaultValue, version);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException("Something went wrong while recovering " + key + " from vault");
            }
        }
        return returnValue;
    }

    private String getSecretFromSource(String key, String subkey, String defaultValue, String version) throws JsonProcessingException {
        String returnValue;
        this.secrets.add(key);
        try {
            KeyVaultSecret secret = this.client.getSecret(key, ObjectHelper.isNotEmpty((String)version) ? version : "");
            returnValue = secret.getValue();
            if (ObjectHelper.isNotEmpty((String)subkey)) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode actualObj = mapper.readTree(returnValue);
                JsonNode field = actualObj.get(subkey);
                returnValue = ObjectHelper.isNotEmpty((Object)field) ? field.textValue() : null;
            }
            if (ObjectHelper.isEmpty((String)returnValue)) {
                returnValue = defaultValue;
            }
        }
        catch (ResourceNotFoundException ex) {
            if (ObjectHelper.isNotEmpty((String)defaultValue)) {
                returnValue = defaultValue;
            }
            throw ex;
        }
        return returnValue;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Set<String> getSecrets() {
        return this.secrets;
    }
}

