/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.key.vault;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.key.vault.CredentialType;
import org.apache.camel.component.azure.key.vault.KeyVaultConfiguration;
import org.apache.camel.component.azure.key.vault.KeyVaultConstants;
import org.apache.camel.component.azure.key.vault.KeyVaultProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.17.0", scheme="azure-key-vault", title="Azure Key Vault", syntax="azure-key-vault:vaultName", category={Category.CLOUD, Category.CLOUD}, producerOnly=true, headersClass=KeyVaultConstants.class)
@Metadata(annotations={"vault=azure-key-vault"})
public class KeyVaultEndpoint
extends DefaultEndpoint {
    private SecretClient secretClient;
    @UriParam
    private KeyVaultConfiguration configuration;

    public KeyVaultEndpoint(String uri, Component component, KeyVaultConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public void doInit() throws Exception {
        super.doInit();
        this.secretClient = this.configuration.getSecretClient() != null ? this.configuration.getSecretClient() : this.createSecretClient();
    }

    private SecretClient createSecretClient() {
        String keyVaultUri = "https://" + this.getConfiguration().getVaultName() + ".vault.azure.net";
        DefaultAzureCredential credential = null;
        if (this.configuration.getCredentialType().equals((Object)CredentialType.CLIENT_SECRET)) {
            credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(this.getConfiguration().getTenantId())).clientId(this.getConfiguration().getClientId())).clientSecret(this.getConfiguration().getClientSecret()).build();
        } else if (this.configuration.getCredentialType().equals((Object)CredentialType.AZURE_IDENTITY)) {
            credential = new DefaultAzureCredentialBuilder().build();
        }
        SecretClient localClient = new SecretClientBuilder().vaultUrl(keyVaultUri).credential((TokenCredential)credential).buildClient();
        return localClient;
    }

    public Producer createProducer() throws Exception {
        return new KeyVaultProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public KeyVaultConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KeyVaultConfiguration configuration) {
        this.configuration = configuration;
    }

    public SecretClient getSecretClient() {
        return this.secretClient;
    }

    public void setSecretClient(SecretClient secretClient) {
        this.secretClient = secretClient;
    }
}

