/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.util.BinaryData;
import com.azure.messaging.servicebus.ServiceBusMessage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ServiceBusUtils {
    private ServiceBusUtils() {
    }

    public static ServiceBusMessage createServiceBusMessage(Object data) {
        if (data instanceof String) {
            return new ServiceBusMessage((String)data);
        }
        if (data instanceof byte[]) {
            return new ServiceBusMessage((byte[])data);
        }
        if (data instanceof BinaryData) {
            return new ServiceBusMessage((BinaryData)data);
        }
        throw new IllegalArgumentException("Make sure your message data is in String, byte[] or BinaryData");
    }

    public static Iterable<ServiceBusMessage> createServiceBusMessages(Iterable<Object> data) {
        return StreamSupport.stream(data.spliterator(), false).map(ServiceBusUtils::createServiceBusMessage).collect(Collectors.toList());
    }
}

