/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.operations;

import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.camel.component.azure.servicebus.ServiceBusUtils;
import org.apache.camel.component.azure.servicebus.client.ServiceBusSenderAsyncClientWrapper;
import org.apache.camel.util.ObjectHelper;
import reactor.core.publisher.Mono;

public class ServiceBusSenderOperations {
    private final ServiceBusSenderAsyncClientWrapper client;

    public ServiceBusSenderOperations(ServiceBusSenderAsyncClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client");
        this.client = client;
    }

    public Mono<Void> sendMessages(Object data, ServiceBusTransactionContext context) {
        if (data instanceof Iterable) {
            return this.sendMessages((Iterable)data, context);
        }
        return this.sendMessage(data, context);
    }

    public Mono<List<Long>> scheduleMessages(Object data, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext context) {
        if (ObjectHelper.isEmpty((Object)scheduledEnqueueTime)) {
            throw new IllegalArgumentException("To schedule a message, you need to set scheduledEnqueueTime.");
        }
        if (data instanceof Iterable) {
            return this.scheduleMessages((Iterable)data, scheduledEnqueueTime, context);
        }
        return this.scheduleMessage(data, scheduledEnqueueTime, context);
    }

    private Mono<Void> sendMessages(Iterable<Object> data, ServiceBusTransactionContext context) {
        Iterable<ServiceBusMessage> messages = ServiceBusUtils.createServiceBusMessages(data);
        if (ObjectHelper.isEmpty((Object)context)) {
            return this.client.sendMessages(messages);
        }
        return this.client.sendMessages(messages, context);
    }

    private Mono<Void> sendMessage(Object data, ServiceBusTransactionContext context) {
        ServiceBusMessage message = ServiceBusUtils.createServiceBusMessage(data);
        if (ObjectHelper.isEmpty((Object)context)) {
            return this.client.sendMessage(message);
        }
        return this.client.sendMessage(message, context);
    }

    private Mono<List<Long>> scheduleMessage(Object data, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext context) {
        ServiceBusMessage message = ServiceBusUtils.createServiceBusMessage(data);
        if (ObjectHelper.isEmpty((Object)context)) {
            return this.client.scheduleMessage(message, scheduledEnqueueTime).map(Collections::singletonList);
        }
        return this.client.scheduleMessage(message, scheduledEnqueueTime, context).map(Collections::singletonList);
    }

    private Mono<List<Long>> scheduleMessages(Iterable<Object> data, OffsetDateTime scheduledEnqueueTime, ServiceBusTransactionContext context) {
        Iterable<ServiceBusMessage> messages = ServiceBusUtils.createServiceBusMessages(data);
        if (ObjectHelper.isEmpty((Object)context)) {
            return this.client.scheduleMessages(messages, scheduledEnqueueTime).collectList();
        }
        return this.client.scheduleMessages(messages, scheduledEnqueueTime, context).collectList();
    }
}

