/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.client;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusType;
import org.apache.camel.util.ObjectHelper;

public final class ServiceBusClientFactory {
    private ServiceBusClientFactory() {
    }

    public static ServiceBusSenderAsyncClient createServiceBusSenderAsyncClient(ServiceBusConfiguration configuration) {
        return ServiceBusClientFactory.createBaseServiceBusSenderClient(ServiceBusClientFactory.createBaseServiceBusClient(configuration), configuration).buildAsyncClient();
    }

    public static ServiceBusReceiverAsyncClient createServiceBusReceiverAsyncClient(ServiceBusConfiguration configuration) {
        return ServiceBusClientFactory.createBaseServiceBusReceiverClient(ServiceBusClientFactory.createBaseServiceBusClient(configuration), configuration).prefetchCount(configuration.getPrefetchCount()).receiveMode(configuration.getServiceBusReceiveMode()).subQueue(configuration.getSubQueue()).maxAutoLockRenewDuration(configuration.getMaxAutoLockRenewDuration()).subscriptionName(configuration.getSubscriptionName()).buildAsyncClient();
    }

    private static ServiceBusClientBuilder createBaseServiceBusClient(ServiceBusConfiguration configuration) {
        ServiceBusClientBuilder builder = new ServiceBusClientBuilder().transportType(configuration.getAmqpTransportType()).clientOptions(configuration.getClientOptions()).retryOptions(configuration.getAmqpRetryOptions()).proxyOptions(configuration.getProxyOptions());
        String fullyQualifiedNamespace = configuration.getFullyQualifiedNamespace();
        TokenCredential credential = configuration.getTokenCredential();
        if (ObjectHelper.isNotEmpty((String)fullyQualifiedNamespace) && ObjectHelper.isNotEmpty((Object)credential)) {
            builder.credential(fullyQualifiedNamespace, credential);
        } else {
            builder.connectionString(configuration.getConnectionString());
        }
        return builder;
    }

    private static ServiceBusClientBuilder.ServiceBusSenderClientBuilder createBaseServiceBusSenderClient(ServiceBusClientBuilder busClientBuilder, ServiceBusConfiguration configuration) {
        if (configuration.getServiceBusType() == ServiceBusType.queue) {
            return busClientBuilder.sender().queueName(configuration.getTopicOrQueueName());
        }
        return busClientBuilder.sender().topicName(configuration.getTopicOrQueueName());
    }

    private static ServiceBusClientBuilder.ServiceBusReceiverClientBuilder createBaseServiceBusReceiverClient(ServiceBusClientBuilder busClientBuilder, ServiceBusConfiguration configuration) {
        ServiceBusClientBuilder.ServiceBusReceiverClientBuilder receiverClientBuilder = busClientBuilder.receiver();
        if (configuration.isDisableAutoComplete()) {
            receiverClientBuilder.disableAutoComplete();
        }
        if (configuration.getServiceBusType() == ServiceBusType.queue) {
            return receiverClientBuilder.queueName(configuration.getTopicOrQueueName());
        }
        return receiverClientBuilder.topicName(configuration.getTopicOrQueueName());
    }
}

