/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.client;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import java.util.function.Consumer;
import org.apache.camel.component.azure.servicebus.CredentialType;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusType;

public final class ServiceBusClientFactory {
    private static ServiceBusClientBuilder createBaseServiceBusClient(ServiceBusConfiguration configuration) {
        ServiceBusClientBuilder builder = new ServiceBusClientBuilder().transportType(configuration.getAmqpTransportType()).clientOptions(configuration.getClientOptions()).retryOptions(configuration.getAmqpRetryOptions()).proxyOptions(configuration.getProxyOptions());
        String fullyQualifiedNamespace = configuration.getFullyQualifiedNamespace();
        TokenCredential credential = configuration.getTokenCredential();
        CredentialType type = configuration.getCredentialType();
        if (type == null) {
            type = CredentialType.CONNECTION_STRING;
        }
        switch (type) {
            case CONNECTION_STRING: {
                builder.connectionString(configuration.getConnectionString());
                break;
            }
            case TOKEN_CREDENTIAL: {
                builder.credential(fullyQualifiedNamespace, credential);
                break;
            }
            case AZURE_IDENTITY: {
                builder.credential(fullyQualifiedNamespace, (TokenCredential)new DefaultAzureCredentialBuilder().build());
            }
        }
        return builder;
    }

    private static ServiceBusClientBuilder.ServiceBusSenderClientBuilder createBaseServiceBusSenderClient(ServiceBusClientBuilder busClientBuilder, ServiceBusConfiguration configuration) {
        if (configuration.getServiceBusType() == ServiceBusType.queue) {
            return busClientBuilder.sender().queueName(configuration.getTopicOrQueueName());
        }
        return busClientBuilder.sender().topicName(configuration.getTopicOrQueueName());
    }

    private static ServiceBusClientBuilder.ServiceBusProcessorClientBuilder createBaseServiceBusProcessorClient(ServiceBusClientBuilder busClientBuilder, ServiceBusConfiguration configuration) {
        ServiceBusClientBuilder.ServiceBusProcessorClientBuilder processorClientBuilder = busClientBuilder.processor();
        processorClientBuilder.disableAutoComplete();
        switch (configuration.getServiceBusType()) {
            case queue: {
                processorClientBuilder.queueName(configuration.getTopicOrQueueName());
                break;
            }
            case topic: {
                processorClientBuilder.topicName(configuration.getTopicOrQueueName());
            }
        }
        return processorClientBuilder;
    }

    private static ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder createBaseServiceBusSessionProcessorClient(ServiceBusClientBuilder busClientBuilder, ServiceBusConfiguration configuration) {
        ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder processorClientBuilder = busClientBuilder.sessionProcessor();
        processorClientBuilder.disableAutoComplete();
        switch (configuration.getServiceBusType()) {
            case queue: {
                processorClientBuilder.queueName(configuration.getTopicOrQueueName());
                break;
            }
            case topic: {
                processorClientBuilder.topicName(configuration.getTopicOrQueueName());
            }
        }
        return processorClientBuilder;
    }

    public ServiceBusSenderClient createServiceBusSenderClient(ServiceBusConfiguration configuration) {
        return ServiceBusClientFactory.createBaseServiceBusSenderClient(ServiceBusClientFactory.createBaseServiceBusClient(configuration), configuration).buildClient();
    }

    public ServiceBusProcessorClient createServiceBusProcessorClient(ServiceBusConfiguration configuration, Consumer<ServiceBusReceivedMessageContext> processMessage, Consumer<ServiceBusErrorContext> processError) {
        ServiceBusClientBuilder.ServiceBusProcessorClientBuilder clientBuilder = ServiceBusClientFactory.createBaseServiceBusProcessorClient(ServiceBusClientFactory.createBaseServiceBusClient(configuration), configuration);
        clientBuilder.subscriptionName(configuration.getSubscriptionName()).receiveMode(configuration.getServiceBusReceiveMode()).maxAutoLockRenewDuration(configuration.getMaxAutoLockRenewDuration()).prefetchCount(configuration.getPrefetchCount()).subQueue(configuration.getSubQueue()).maxConcurrentCalls(configuration.getMaxConcurrentCalls()).processMessage(processMessage).processError(processError);
        return clientBuilder.buildProcessorClient();
    }

    public ServiceBusProcessorClient createServiceBusSessionProcessorClient(ServiceBusConfiguration configuration, Consumer<ServiceBusReceivedMessageContext> processMessage, Consumer<ServiceBusErrorContext> processError) {
        ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder clientBuilder = ServiceBusClientFactory.createBaseServiceBusSessionProcessorClient(ServiceBusClientFactory.createBaseServiceBusClient(configuration), configuration);
        clientBuilder.subscriptionName(configuration.getSubscriptionName()).receiveMode(configuration.getServiceBusReceiveMode()).maxAutoLockRenewDuration(configuration.getMaxAutoLockRenewDuration()).prefetchCount(configuration.getPrefetchCount()).subQueue(configuration.getSubQueue()).maxConcurrentCalls(configuration.getMaxConcurrentCalls()).processMessage(processMessage).processError(processError);
        return clientBuilder.buildProcessorClient();
    }
}

