/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.identity.DefaultAzureCredential;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.servicebus.CredentialType;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="azure-servicebus")
public class ServiceBusComponent
extends DefaultComponent {
    @Metadata
    private ServiceBusConfiguration configuration = new ServiceBusConfiguration();

    public ServiceBusComponent() {
    }

    public ServiceBusComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("A queue or topic name must be specified.");
        }
        ServiceBusConfiguration configuration = this.configuration != null ? this.configuration.copy() : new ServiceBusConfiguration();
        configuration.setTopicOrQueueName(remaining);
        ServiceBusEndpoint endpoint = new ServiceBusEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().getTokenCredential() == null) {
            if (endpoint.getConfiguration().getCredentialType() == null) {
                endpoint.getConfiguration().setCredentialType(CredentialType.CONNECTION_STRING);
            }
        } else {
            boolean azure = endpoint.getConfiguration().getTokenCredential() instanceof DefaultAzureCredential;
            endpoint.getConfiguration().setCredentialType(azure ? CredentialType.AZURE_IDENTITY : CredentialType.TOKEN_CREDENTIAL);
        }
        return endpoint;
    }

    public ServiceBusConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceBusConfiguration configuration) {
        this.configuration = configuration;
    }
}

