/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.servicebus.CredentialType;
import org.apache.camel.component.azure.servicebus.ServiceBusConsumerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusHeaderFilterStrategy;
import org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusType;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class ServiceBusConfiguration
implements Cloneable,
HeaderFilterStrategyAware {
    @UriPath
    private String topicOrQueueName;
    @UriParam(label="common", defaultValue="queue")
    @Metadata(required=true)
    private ServiceBusType serviceBusType = ServiceBusType.queue;
    @UriParam(label="security", secret=true)
    private String connectionString;
    @UriParam(label="security")
    private String fullyQualifiedNamespace;
    @UriParam(label="security", secret=true)
    private TokenCredential tokenCredential;
    @UriParam(label="common")
    private ClientOptions clientOptions;
    @UriParam(label="common")
    private ProxyOptions proxyOptions;
    @UriParam(label="common")
    private AmqpRetryOptions amqpRetryOptions;
    @UriParam(label="common", defaultValue="AMQP")
    private AmqpTransportType amqpTransportType = AmqpTransportType.AMQP;
    @UriParam(label="common", description="To use a custom HeaderFilterStrategy to filter Service Bus application properties to and from Camel message headers.")
    private HeaderFilterStrategy headerFilterStrategy = new ServiceBusHeaderFilterStrategy();
    @UriParam(label="consumer", defaultValue="receiveMessages")
    private ServiceBusConsumerOperationDefinition consumerOperation = ServiceBusConsumerOperationDefinition.receiveMessages;
    @UriParam(label="consumer")
    @Metadata(autowired=true)
    private ServiceBusReceiverAsyncClient receiverAsyncClient;
    @UriParam(label="consumer")
    private String subscriptionName;
    @UriParam(label="consumer")
    private boolean disableAutoComplete;
    @UriParam(label="consumer", defaultValue="PEEK_LOCK")
    private ServiceBusReceiveMode serviceBusReceiveMode = ServiceBusReceiveMode.PEEK_LOCK;
    @UriParam(label="consumer", defaultValue="5m")
    private Duration maxAutoLockRenewDuration = Duration.ofMinutes(5L);
    @UriParam(label="consumer")
    private int prefetchCount;
    @UriParam(label="consumer")
    private SubQueue subQueue;
    @UriParam(label="consumer")
    private Integer peekNumMaxMessages;
    @UriParam(label="producer", defaultValue="sendMessages")
    private ServiceBusProducerOperationDefinition producerOperation = ServiceBusProducerOperationDefinition.sendMessages;
    @UriParam(label="producer")
    @Metadata(autowired=true)
    private ServiceBusSenderAsyncClient senderAsyncClient;
    @UriParam(label="producer")
    private ServiceBusTransactionContext serviceBusTransactionContext;
    @UriParam(label="producer")
    private OffsetDateTime scheduledEnqueueTime;
    @UriParam(label="producer")
    private boolean binary;
    @UriParam(label="security", enums="AZURE_IDENTITY,CONNECTION_STRING,TOKEN_CREDENTIAL", defaultValue="CONNECTION_STRING")
    private CredentialType credentialType = CredentialType.CONNECTION_STRING;
    @UriParam(label="consumer,advanced", defaultValue="5000")
    private int reconnectDelay = 5000;

    public String getTopicOrQueueName() {
        return this.topicOrQueueName;
    }

    public void setTopicOrQueueName(String topicOrQueueName) {
        this.topicOrQueueName = topicOrQueueName;
    }

    public ServiceBusType getServiceBusType() {
        return this.serviceBusType;
    }

    public void setServiceBusType(ServiceBusType serviceBusType) {
        this.serviceBusType = serviceBusType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
    }

    public AmqpRetryOptions getAmqpRetryOptions() {
        return this.amqpRetryOptions;
    }

    public void setAmqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
        this.amqpRetryOptions = amqpRetryOptions;
    }

    public AmqpTransportType getAmqpTransportType() {
        return this.amqpTransportType;
    }

    public void setAmqpTransportType(AmqpTransportType amqpTransportType) {
        this.amqpTransportType = amqpTransportType;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public ServiceBusReceiverAsyncClient getReceiverAsyncClient() {
        return this.receiverAsyncClient;
    }

    public void setReceiverAsyncClient(ServiceBusReceiverAsyncClient receiverAsyncClient) {
        this.receiverAsyncClient = receiverAsyncClient;
    }

    public boolean isDisableAutoComplete() {
        return this.disableAutoComplete;
    }

    public void setDisableAutoComplete(boolean disableAutoComplete) {
        this.disableAutoComplete = disableAutoComplete;
    }

    public ServiceBusReceiveMode getServiceBusReceiveMode() {
        return this.serviceBusReceiveMode;
    }

    public void setServiceBusReceiveMode(ServiceBusReceiveMode serviceBusReceiveMode) {
        this.serviceBusReceiveMode = serviceBusReceiveMode;
    }

    public Duration getMaxAutoLockRenewDuration() {
        return this.maxAutoLockRenewDuration;
    }

    public void setMaxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
        this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public SubQueue getSubQueue() {
        return this.subQueue;
    }

    public void setSubQueue(SubQueue subQueue) {
        this.subQueue = subQueue;
    }

    public ServiceBusSenderAsyncClient getSenderAsyncClient() {
        return this.senderAsyncClient;
    }

    public void setSenderAsyncClient(ServiceBusSenderAsyncClient senderAsyncClient) {
        this.senderAsyncClient = senderAsyncClient;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public void setFullyQualifiedNamespace(String fullyQualifiedNamespace) {
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public void setTokenCredential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
    }

    public ServiceBusConsumerOperationDefinition getConsumerOperation() {
        return this.consumerOperation;
    }

    public void setConsumerOperation(ServiceBusConsumerOperationDefinition consumerOperation) {
        this.consumerOperation = consumerOperation;
    }

    public ServiceBusProducerOperationDefinition getProducerOperation() {
        return this.producerOperation;
    }

    public void setProducerOperation(ServiceBusProducerOperationDefinition producerOperation) {
        this.producerOperation = producerOperation;
    }

    public ServiceBusTransactionContext getServiceBusTransactionContext() {
        return this.serviceBusTransactionContext;
    }

    public void setServiceBusTransactionContext(ServiceBusTransactionContext serviceBusTransactionContext) {
        this.serviceBusTransactionContext = serviceBusTransactionContext;
    }

    public OffsetDateTime getScheduledEnqueueTime() {
        return this.scheduledEnqueueTime;
    }

    public void setScheduledEnqueueTime(OffsetDateTime scheduledEnqueueTime) {
        this.scheduledEnqueueTime = scheduledEnqueueTime;
    }

    public Integer getPeekNumMaxMessages() {
        return this.peekNumMaxMessages;
    }

    public void setPeekNumMaxMessages(Integer peekNumMaxMessages) {
        this.peekNumMaxMessages = peekNumMaxMessages;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public ServiceBusConfiguration copy() {
        try {
            return (ServiceBusConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

