/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.client;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.azure.storage.blob.client.BlobClientWrapper;
import org.apache.camel.util.ObjectHelper;

public class BlobContainerClientWrapper {
    private final BlobContainerClient client;

    public BlobContainerClientWrapper(BlobContainerClient client) {
        this.client = client;
    }

    public HttpHeaders createContainer(Map<String, String> metadata, PublicAccessType publicAccessType, Duration timeout) {
        return this.client.createWithResponse(metadata, publicAccessType, timeout, Context.NONE).getHeaders();
    }

    public HttpHeaders deleteContainer(BlobRequestConditions blobRequestConditions, Duration timeout) {
        return this.client.deleteWithResponse(blobRequestConditions, timeout, Context.NONE).getHeaders();
    }

    public List<BlobItem> listBlobs(ListBlobsOptions listBlobsOptions, Duration timeout) {
        return this.client.listBlobs(listBlobsOptions, timeout).stream().collect(Collectors.toList());
    }

    public BlobClientWrapper getBlobClientWrapper(String blobName) {
        if (!ObjectHelper.isEmpty((Object)blobName)) {
            return new BlobClientWrapper(this.client.getBlobClient(blobName));
        }
        throw new IllegalArgumentException("Cannot initialize a blob since no blob name was provided.");
    }
}

