/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="azure-storage-blob")
public class BlobComponent
extends DefaultComponent {
    @Metadata
    private BlobConfiguration configuration = new BlobConfiguration();

    public BlobComponent() {
    }

    public BlobComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("At least the account name must be specified.");
        }
        BlobConfiguration config = this.configuration != null ? this.configuration.copy() : new BlobConfiguration();
        String[] parts = remaining.split("/");
        config.setAccountName(parts[0]);
        if (parts.length > 1) {
            config.setContainerName(parts[1]);
        }
        BlobEndpoint endpoint = new BlobEndpoint(uri, (Component)this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkCredentials(config);
        this.validateConfigurations(config);
        return endpoint;
    }

    public BlobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkCredentials(BlobConfiguration configuration) {
        Set storageSharedKeyCredentials;
        BlobServiceClient client = configuration.getServiceClient();
        if (client == null && (storageSharedKeyCredentials = this.getCamelContext().getRegistry().findByType(StorageSharedKeyCredential.class)).size() == 1) {
            configuration.setCredentials((StorageSharedKeyCredential)storageSharedKeyCredentials.stream().findFirst().get());
        }
    }

    private void validateConfigurations(BlobConfiguration configuration) {
        if (configuration.getServiceClient() == null && configuration.getAccessKey() == null && configuration.getCredentials() == null) {
            throw new IllegalArgumentException("Azure Storage accessKey or BlobServiceClient must be specified.");
        }
    }
}

