/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.util.ObjectHelper;

public final class BlobUtils {
    private BlobUtils() {
    }

    public static Message getInMessage(Exchange exchange) {
        return ObjectHelper.isEmpty((Object)exchange) ? null : exchange.getIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getInputStreamLength(InputStream is) throws IOException {
        long len;
        if (is instanceof StreamCache && (len = ((StreamCache)is).length()) > 0L) {
            return len;
        }
        if (!is.markSupported()) {
            return 0L;
        }
        if (is instanceof ByteArrayInputStream) {
            return is.available();
        }
        long size = 0L;
        try {
            is.mark(1024);
            int i = is.available();
            while (i > 0) {
                long skip = is.skip(i);
                size += skip;
                i = is.available();
            }
        }
        finally {
            is.reset();
        }
        return size;
    }

    public static String getContainerName(BlobConfiguration configuration, Exchange exchange) {
        return ObjectHelper.isEmpty((Object)BlobExchangeHeaders.getBlobContainerNameFromHeaders(exchange)) ? configuration.getContainerName() : BlobExchangeHeaders.getBlobContainerNameFromHeaders(exchange);
    }

    public static String getBlobName(BlobConfiguration configuration, Exchange exchange) {
        return ObjectHelper.isEmpty((Object)BlobExchangeHeaders.getBlobNameFromHeaders(exchange)) ? configuration.getBlobName() : BlobExchangeHeaders.getBlobNameFromHeaders(exchange);
    }
}

