/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.storage.blob.models.ListBlobContainersOptions;
import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.component.azure.storage.blob.client.BlobServiceClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class BlobServiceOperations {
    private final BlobServiceClientWrapper client;

    public BlobServiceOperations(BlobServiceClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
    }

    public BlobOperationResponse listBlobContainers(Exchange exchange) {
        if (exchange == null) {
            return new BlobOperationResponse(this.client.listBlobContainers(null, null));
        }
        ListBlobContainersOptions listBlobContainersOptions = BlobExchangeHeaders.getListBlobContainersOptionsFromHeaders(exchange);
        Duration timeout = BlobExchangeHeaders.getTimeoutFromHeaders(exchange);
        return new BlobOperationResponse(this.client.listBlobContainers(listBlobContainersOptions, timeout));
    }
}

