/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class BlobConfiguration
implements Cloneable {
    @UriPath
    private String accountName;
    @UriPath
    private String containerName;
    @UriParam
    private StorageSharedKeyCredential credentials;
    @UriParam
    private BlobServiceClient serviceClient;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="producer", enums="listBlobContainers,createBlobContainer,deleteBlobContainer,listBlobs,getBlob,deleteBlob,downloadBlobToFile,downloadLink,uploadBlockBlob,stageBlockBlobList,commitBlobBlockList,getBlobBlockList,createAppendBlob,commitAppendBlob,createPageBlob,uploadPageBlob,resizePageBlob,clearPageBlob,getPageBlobRanges", defaultValue="listBlobContainers")
    private BlobOperationsDefinition operation = BlobOperationsDefinition.listBlobContainers;
    @UriParam(label="common")
    private String blobName;
    @UriParam(label="common", enums="blockblob,appendblob,pageblob", defaultValue="blockblob")
    private BlobType blobType = BlobType.blockblob;
    @UriParam(label="common")
    private String fileDir;
    @UriParam(label="common", defaultValue="0")
    private long blobOffset;
    @UriParam(label="common")
    private Long dataCount;
    @UriParam(label="common", defaultValue="0")
    private int maxRetryRequests;
    @UriParam(defaultValue="true")
    private boolean closeStreamAfterRead = true;
    @UriParam(label="producer", defaultValue="true")
    private boolean closeStreamAfterWrite = true;

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public StorageSharedKeyCredential getCredentials() {
        return this.credentials;
    }

    public void setCredentials(StorageSharedKeyCredential credentials) {
        this.credentials = credentials;
    }

    public BlobServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public void setServiceClient(BlobServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public BlobOperationsDefinition getOperation() {
        return this.operation;
    }

    public void setOperation(BlobOperationsDefinition operation) {
        this.operation = operation;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public void setBlobName(String blobName) {
        this.blobName = blobName;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public void setBlobType(BlobType blobType) {
        this.blobType = blobType;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public long getBlobOffset() {
        return this.blobOffset;
    }

    public void setBlobOffset(long blobOffset) {
        this.blobOffset = blobOffset;
    }

    public Long getDataCount() {
        return this.dataCount;
    }

    public void setDataCount(Long dataCount) {
        this.dataCount = dataCount;
    }

    public int getMaxRetryRequests() {
        return this.maxRetryRequests;
    }

    public void setMaxRetryRequests(int maxRetryRequests) {
        this.maxRetryRequests = maxRetryRequests;
    }

    public boolean isCloseStreamAfterRead() {
        return this.closeStreamAfterRead;
    }

    public void setCloseStreamAfterRead(boolean closeStreamAfterRead) {
        this.closeStreamAfterRead = closeStreamAfterRead;
    }

    public boolean isCloseStreamAfterWrite() {
        return this.closeStreamAfterWrite;
    }

    public void setCloseStreamAfterWrite(boolean closeStreamAfterWrite) {
        this.closeStreamAfterWrite = closeStreamAfterWrite;
    }

    public BlobConfiguration copy() {
        try {
            return (BlobConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

