/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.azure.storage.blob.BlobCommonRequestOptions;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobExchangeHeaders;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.IOUtils;

public final class BlobUtils {
    private BlobUtils() {
    }

    public static Message getInMessage(Exchange exchange) {
        return exchange.getIn();
    }

    public static Long getInputStreamLength(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Reset inputStream is not supported, provide an inputstream with supported mark/reset.");
        }
        long length = IOUtils.toByteArray((InputStream)inputStream).length;
        inputStream.reset();
        return length;
    }

    public static BlobCommonRequestOptions getCommonRequestOptions(Exchange exchange) {
        BlobHttpHeaders blobHttpHeaders = BlobExchangeHeaders.getBlobHttpHeadersFromHeaders(exchange);
        Map<String, String> metadata = BlobExchangeHeaders.getMetadataFromHeaders(exchange);
        AccessTier accessTier = BlobExchangeHeaders.getAccessTierFromHeaders(exchange);
        BlobRequestConditions blobRequestConditions = BlobExchangeHeaders.getBlobRequestConditionsFromHeaders(exchange);
        Duration timeout = BlobExchangeHeaders.getTimeoutFromHeaders(exchange);
        byte[] contentMD5 = BlobExchangeHeaders.getContentMd5FromHeaders(exchange);
        return new BlobCommonRequestOptions(blobHttpHeaders, metadata, accessTier, blobRequestConditions, contentMD5, timeout);
    }

    public static String getContainerName(BlobConfiguration configuration, Exchange exchange) {
        return ObjectHelper.isEmpty((Object)BlobExchangeHeaders.getBlobContainerNameFromHeaders(exchange)) ? configuration.getContainerName() : BlobExchangeHeaders.getBlobContainerNameFromHeaders(exchange);
    }

    public static String getBlobName(BlobConfiguration configuration, Exchange exchange) {
        return ObjectHelper.isEmpty((Object)BlobExchangeHeaders.getBlobNameFromHeaders(exchange)) ? configuration.getBlobName() : BlobExchangeHeaders.getBlobNameFromHeaders(exchange);
    }
}

