/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.core.http.HttpHeaders;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;

public class BlobExchangeHeaders {
    private final Map<String, Object> headers = new HashMap<String, Object>();

    public static BlobExchangeHeaders createBlobExchangeHeadersFromBlobProperties(BlobProperties properties) {
        return new BlobExchangeHeaders().accessTierHeader(properties.getAccessTier()).accessTierChangeTime(properties.getAccessTierChangeTime()).archiveStatus(properties.getArchiveStatus()).blobSequenceNumber(properties.getBlobSequenceNumber()).blobSize(properties.getBlobSize()).blobType(properties.getBlobType()).cacheControl(properties.getCacheControl()).committedBlockCount(properties.getCommittedBlockCount()).contentDisposition(properties.getContentDisposition()).contentEncoding(properties.getContentEncoding()).contentLanguage(properties.getContentLanguage()).contentMd5(properties.getContentMd5()).contentType(properties.getContentType()).copyCompletionTime(properties.getCopyCompletionTime()).copyDestinationSnapshot(properties.getCopyDestinationSnapshot()).copyId(properties.getCopyId()).copyProgress(properties.getCopyProgress()).copySource(properties.getCopySource()).copyStatus(properties.getCopyStatus()).copyStatusDescription(properties.getCopyStatusDescription()).creationTime(properties.getCreationTime()).encryptionKeySha256(properties.getEncryptionKeySha256()).eTag(properties.getETag()).isAccessTierInferred(properties.isAccessTierInferred()).isIncrementalCopy(properties.isIncrementalCopy()).isServerEncrypted(properties.isServerEncrypted()).lastModified(properties.getLastModified()).leaseDuration(properties.getLeaseDuration()).leaseState(properties.getLeaseState()).leaseStatus(properties.getLeaseStatus()).metadata(properties.getMetadata());
    }

    public static BlobExchangeHeaders createBlobExchangeHeadersFromBlobDownloadHeaders(BlobDownloadHeaders blobDownloadHeaders) {
        return BlobExchangeHeaders.createBlobExchangeHeadersFromBlobProperties(BlobExchangeHeaders.buildBlobProperties(blobDownloadHeaders));
    }

    public static BlobExchangeHeaders createBlobExchangeHeadersFromBlockBlobItem(BlockBlobItem blockBlobItem) {
        return new BlobExchangeHeaders().eTag(blockBlobItem.getETag()).lastModified(blockBlobItem.getLastModified()).contentMd5(blockBlobItem.getContentMd5()).isServerEncrypted(blockBlobItem.isServerEncrypted()).encryptionKeySha256(blockBlobItem.getEncryptionKeySha256()).encryptionScope(blockBlobItem.getEncryptionScope());
    }

    public static BlobExchangeHeaders createBlobExchangeHeadersFromAppendBlobItem(AppendBlobItem appendBlobItem) {
        return new BlobExchangeHeaders().eTag(appendBlobItem.getETag()).lastModified(appendBlobItem.getLastModified()).contentMd5(appendBlobItem.getContentMd5()).isServerEncrypted(appendBlobItem.isServerEncrypted()).encryptionKeySha256(appendBlobItem.getEncryptionKeySha256()).encryptionScope(appendBlobItem.getEncryptionScope()).appendOffset(appendBlobItem.getBlobAppendOffset()).committedBlockCount(appendBlobItem.getBlobCommittedBlockCount());
    }

    public static BlobExchangeHeaders createBlobExchangeHeadersFromPageBlobItem(PageBlobItem pageBlobItem) {
        return new BlobExchangeHeaders().eTag(pageBlobItem.getETag()).lastModified(pageBlobItem.getLastModified()).contentMd5(pageBlobItem.getContentMd5()).isServerEncrypted(pageBlobItem.isServerEncrypted()).encryptionScope(pageBlobItem.getEncryptionScope()).blobSequenceNumber(pageBlobItem.getBlobSequenceNumber());
    }

    public static BlobExchangeHeaders create() {
        return new BlobExchangeHeaders();
    }

    private static BlobProperties buildBlobProperties(BlobDownloadHeaders hd) {
        return new BlobProperties(null, hd.getLastModified(), hd.getETag(), hd.getContentLength() == null ? 0L : hd.getContentLength(), hd.getContentType(), null, hd.getContentEncoding(), hd.getContentDisposition(), hd.getContentLanguage(), hd.getCacheControl(), hd.getBlobSequenceNumber(), hd.getBlobType(), hd.getLeaseStatus(), hd.getLeaseState(), hd.getLeaseDuration(), hd.getCopyId(), hd.getCopyStatus(), hd.getCopySource(), hd.getCopyProgress(), hd.getCopyCompletionTime(), hd.getCopyStatusDescription(), hd.isServerEncrypted(), null, null, null, null, null, hd.getEncryptionKeySha256(), null, hd.getMetadata(), hd.getBlobCommittedBlockCount());
    }

    public static Duration getTimeoutFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobTimeout", Duration.class);
    }

    public static Map<String, String> getMetadataFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobMetadata", Map.class);
    }

    public static PublicAccessType getPublicAccessTypeFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobPublicAccessType", PublicAccessType.class);
    }

    public static BlobRequestConditions getBlobRequestConditionsFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobRequestCondition", BlobRequestConditions.class);
    }

    public static BlobListDetails getBlobListDetailsFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobListDetails", BlobListDetails.class);
    }

    public static ListBlobsOptions getListBlobsOptionsFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobListBlobOptions", ListBlobsOptions.class);
    }

    public static String getPrefixFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobPrefix", String.class);
    }

    public static Integer getMaxResultsPerPageFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobMaxResultsPerPage", Integer.class);
    }

    public static BlobHttpHeaders getBlobHttpHeadersFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobHttpHeaders", BlobHttpHeaders.class);
    }

    public static AccessTier getAccessTierFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobAccessTier", AccessTier.class);
    }

    public static byte[] getContentMd5FromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobContentMD5", byte[].class);
    }

    public static PageRange getPageRangeFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobPageBlobRange", PageRange.class);
    }

    public static boolean getCommitBlockListFlagFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobCommitBlobBlockListLater", Boolean.TYPE);
    }

    public static boolean getCreateAppendBlobFlagFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobCreateAppendBlob", Boolean.TYPE);
    }

    public static boolean getCreatePageBlobFlagFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobCreatePageBlob", Boolean.TYPE);
    }

    public static BlockListType getBlockListTypeFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobBlockListType", BlockListType.class);
    }

    public static Long getPageBlobSize(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobPageBlobSize", Long.class);
    }

    public static Long getBlobSequenceNumberFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobSequenceNumber", Long.class);
    }

    public static DeleteSnapshotsOptionType getDeleteSnapshotsOptionTypeFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobDeleteSnapshotsOptionType", DeleteSnapshotsOptionType.class);
    }

    public static ListBlobContainersOptions getListBlobContainersOptionsFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobListBlobContainersOptions", ListBlobContainersOptions.class);
    }

    public static ParallelTransferOptions getParallelTransferOptionsFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobParallelTransferOptions", ParallelTransferOptions.class);
    }

    public static String getFileDirFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobFileDir", String.class);
    }

    public static Long getDownloadLinkExpirationFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobDownloadLinkExpiration", Long.class);
    }

    public static String getBlobNameFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobBlobName", String.class);
    }

    public static String getBlobContainerNameFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobBlobContainerName", String.class);
    }

    public static BlobOperationsDefinition getBlobOperationsDefinitionFromHeaders(Exchange exchange) {
        return BlobExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageBlobOperation", BlobOperationsDefinition.class);
    }

    private static <T> T getObjectFromHeaders(Exchange exchange, String headerName, Class<T> classType) {
        return (T)exchange.getIn().getHeader(headerName, classType);
    }

    public Map<String, Object> toMap() {
        return this.headers;
    }

    public BlobExchangeHeaders accessTierHeader(AccessTier accessTier) {
        this.headers.put("CamelAzureStorageBlobAccessTier", accessTier);
        return this;
    }

    public BlobExchangeHeaders accessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.headers.put("CamelAzureStorageBlobaccessTierChangeTime", accessTierChangeTime);
        return this;
    }

    public BlobExchangeHeaders archiveStatus(ArchiveStatus archiveStatus) {
        this.headers.put("CamelAzureStorageBlobArchiveStatus", archiveStatus);
        return this;
    }

    public BlobExchangeHeaders creationTime(OffsetDateTime creationTime) {
        this.headers.put("CamelAzureStorageBlobCreationTime", creationTime);
        return this;
    }

    public BlobExchangeHeaders blobSequenceNumber(Long sequence) {
        this.headers.put("CamelAzureStorageBlobSequenceNumber", sequence);
        return this;
    }

    public BlobExchangeHeaders blobSize(long size) {
        this.headers.put("CamelAzureStorageBlobBlobSize", size);
        return this;
    }

    public BlobExchangeHeaders blobType(BlobType blobType) {
        this.headers.put("CamelAzureStorageBlobBlobType", blobType);
        return this;
    }

    public BlobExchangeHeaders cacheControl(String cache) {
        this.headers.put("CamelAzureStorageBlobCacheControl", cache);
        return this;
    }

    public BlobExchangeHeaders committedBlockCount(Integer count) {
        this.headers.put("CamelAzureStorageBlobCommittedBlockCount", count);
        return this;
    }

    public BlobExchangeHeaders contentDisposition(String content) {
        this.headers.put("CamelAzureStorageBlobContentDisposition", content);
        return this;
    }

    public BlobExchangeHeaders contentEncoding(String contentEncoding) {
        this.headers.put("CamelAzureStorageBlobContentEncoding", contentEncoding);
        return this;
    }

    public BlobExchangeHeaders contentLanguage(String contentLanguageHeader) {
        this.headers.put("CamelAzureStorageBlobContentLanguage", contentLanguageHeader);
        return this;
    }

    public BlobExchangeHeaders contentMd5(byte[] md5) {
        this.headers.put("CamelAzureStorageBlobContentMD5", md5);
        return this;
    }

    public BlobExchangeHeaders contentType(String type) {
        this.headers.put("CamelAzureStorageBlobContentType", type);
        return this;
    }

    public BlobExchangeHeaders copyCompletionTime(OffsetDateTime offsetDateTime) {
        this.headers.put("CamelAzureStorageBlobCopyCompletionTime", offsetDateTime);
        return this;
    }

    public BlobExchangeHeaders copyDestinationSnapshot(String copyDest) {
        this.headers.put("CamelAzureStorageBlobCopyDestinationSnapshot", copyDest);
        return this;
    }

    public BlobExchangeHeaders copyId(String copyId) {
        this.headers.put("CamelAzureStorageBlobCopyId", copyId);
        return this;
    }

    public BlobExchangeHeaders copyProgress(String copyProg) {
        this.headers.put("CamelAzureStorageBlobCopyProgress", copyProg);
        return this;
    }

    public BlobExchangeHeaders copySource(String copySource) {
        this.headers.put("CamelAzureStorageBlobCopySource", copySource);
        return this;
    }

    public BlobExchangeHeaders copyStatus(CopyStatusType copyStatusType) {
        this.headers.put("CamelAzureStorageBlobCopyStatus", copyStatusType);
        return this;
    }

    public BlobExchangeHeaders copyStatusDescription(String copyStatusDes) {
        this.headers.put("CamelAzureStorageBlobCopyStatusDescription", copyStatusDes);
        return this;
    }

    public BlobExchangeHeaders encryptionKeySha256(String encryptionKeySha256) {
        this.headers.put("CamelAzureStorageBlobEncryptionKeySha256", encryptionKeySha256);
        return this;
    }

    public BlobExchangeHeaders encryptionScope(String scope) {
        this.headers.put("CamelAzureStorageBlobEncryptionScope", scope);
        return this;
    }

    public BlobExchangeHeaders eTag(String eTag) {
        this.headers.put("CamelAzureStorageBlobETag", eTag);
        return this;
    }

    public BlobExchangeHeaders isAccessTierInferred(Boolean isAccess) {
        this.headers.put("CamelAzureStorageBlobIsAccessTierInferred", isAccess);
        return this;
    }

    public BlobExchangeHeaders isIncrementalCopy(Boolean isIncr) {
        this.headers.put("CamelAzureStorageBlobIsIncrementalCopy", isIncr);
        return this;
    }

    public BlobExchangeHeaders isServerEncrypted(Boolean isServerEncrypted) {
        this.headers.put("CamelAzureStorageBlobIsServerEncrypted", isServerEncrypted);
        return this;
    }

    public BlobExchangeHeaders lastModified(OffsetDateTime offsetDateTime) {
        this.headers.put("CamelAzureStorageBlobLastModified", offsetDateTime);
        return this;
    }

    public BlobExchangeHeaders leaseDuration(LeaseDurationType leaseDurationType) {
        this.headers.put("CamelAzureStorageBlobLeaseDuration", leaseDurationType);
        return this;
    }

    public BlobExchangeHeaders leaseState(LeaseStateType leaseStateType) {
        this.headers.put("CamelAzureStorageBlobLeaseState", leaseStateType);
        return this;
    }

    public BlobExchangeHeaders leaseStatus(LeaseStatusType leaseStatusType) {
        this.headers.put("CamelAzureStorageBlobLeaseStatus", leaseStatusType);
        return this;
    }

    public BlobExchangeHeaders metadata(Map<String, String> metadata) {
        this.headers.put("CamelAzureStorageBlobMetadata", metadata);
        return this;
    }

    public BlobExchangeHeaders appendOffset(String offset) {
        this.headers.put("CamelAzureStorageBlobAppendOffset", offset);
        return this;
    }

    public BlobExchangeHeaders fileName(String fileName) {
        this.headers.put("CamelAzureStorageBlobFileName", fileName);
        return this;
    }

    public BlobExchangeHeaders downloadLink(String downloadLink) {
        this.headers.put("CamelAzureStorageBlobDownloadLink", downloadLink);
        return this;
    }

    public BlobExchangeHeaders httpHeaders(HttpHeaders httpHeaders) {
        this.headers.put("CamelAzureStorageBlobRawHttpHeaders", httpHeaders);
        return this;
    }
}

