/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="azure-storage-blob")
public class BlobComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(BlobComponent.class);
    @Metadata
    private BlobConfiguration configuration = new BlobConfiguration();

    public BlobComponent() {
    }

    public BlobComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("At least the account name must be specified.");
        }
        BlobConfiguration configuration = this.configuration != null ? this.configuration.copy() : new BlobConfiguration();
        String[] parts = remaining.split("/");
        configuration.setAccountName(parts[0]);
        if (parts.length > 1) {
            configuration.setContainerName(parts[1]);
        }
        BlobEndpoint endpoint = new BlobEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        this.checkCredentials(configuration);
        this.validateConfigurations(configuration);
        return endpoint;
    }

    public BlobConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkCredentials(BlobConfiguration configuration) {
        Set storageSharedKeyCredentials;
        BlobServiceClient client = configuration.getServiceClient();
        if (client == null && (storageSharedKeyCredentials = this.getCamelContext().getRegistry().findByType(StorageSharedKeyCredential.class)).size() == 1) {
            configuration.setCredentials((StorageSharedKeyCredential)storageSharedKeyCredentials.stream().findFirst().get());
        }
    }

    private void checkAndSetRegistryClient(BlobConfiguration configuration) {
        if (ObjectHelper.isEmpty((Object)configuration.getServiceClient())) {
            Set clients = this.getCamelContext().getRegistry().findByType(BlobServiceClient.class);
            if (clients.size() == 1) {
                configuration.setServiceClient((BlobServiceClient)clients.stream().findFirst().get());
            } else if (clients.size() > 1) {
                LOG.info("More than one BlobServiceClient instance in the registry, make sure to have only one instance");
            } else {
                LOG.info("No BlobServiceClient instance in the registry");
            }
        } else {
            LOG.info("BlobServiceClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }

    private void validateConfigurations(BlobConfiguration configuration) {
        if (configuration.getServiceClient() == null && configuration.getAccessKey() == null && configuration.getCredentials() == null) {
            throw new IllegalArgumentException("Azure Storage accessKey or BlobServiceClient must be specified.");
        }
    }
}

