/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.storage.blob.BlobComponent;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.component.azure.storage.blob.BlobType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class BlobComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private BlobConfiguration getOrCreateConfiguration(BlobComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new BlobConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        BlobComponent target = (BlobComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)BlobComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "blobname": 
            case "blobName": {
                this.getOrCreateConfiguration(target).setBlobName((String)BlobComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bloboffset": 
            case "blobOffset": {
                this.getOrCreateConfiguration(target).setBlobOffset((Long)BlobComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                this.getOrCreateConfiguration(target).setBlobSequenceNumber((Long)BlobComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "blobtype": 
            case "blobType": {
                this.getOrCreateConfiguration(target).setBlobType((BlobType)((Object)BlobComponentConfigurer.property((CamelContext)camelContext, BlobType.class, (Object)value)));
                return true;
            }
            case "blocklisttype": 
            case "blockListType": {
                this.getOrCreateConfiguration(target).setBlockListType((BlockListType)BlobComponentConfigurer.property((CamelContext)camelContext, BlockListType.class, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterRead((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterWrite((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                this.getOrCreateConfiguration(target).setCommitBlockListLater((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((BlobConfiguration)BlobComponentConfigurer.property((CamelContext)camelContext, BlobConfiguration.class, (Object)value));
                return true;
            }
            case "createappendblob": 
            case "createAppendBlob": {
                this.getOrCreateConfiguration(target).setCreateAppendBlob((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "createpageblob": 
            case "createPageBlob": {
                this.getOrCreateConfiguration(target).setCreatePageBlob((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "credentials": {
                this.getOrCreateConfiguration(target).setCredentials((StorageSharedKeyCredential)BlobComponentConfigurer.property((CamelContext)camelContext, StorageSharedKeyCredential.class, (Object)value));
                return true;
            }
            case "datacount": 
            case "dataCount": {
                this.getOrCreateConfiguration(target).setDataCount((Long)BlobComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                this.getOrCreateConfiguration(target).setDownloadLinkExpiration((Long)BlobComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "filedir": 
            case "fileDir": {
                this.getOrCreateConfiguration(target).setFileDir((String)BlobComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)BlobComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                this.getOrCreateConfiguration(target).setMaxResultsPerPage((Integer)BlobComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                this.getOrCreateConfiguration(target).setMaxRetryRequests((Integer)BlobComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((BlobOperationsDefinition)((Object)BlobComponentConfigurer.property((CamelContext)camelContext, BlobOperationsDefinition.class, (Object)value)));
                return true;
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                this.getOrCreateConfiguration(target).setPageBlobSize((Long)BlobComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix((String)BlobComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serviceclient": 
            case "serviceClient": {
                this.getOrCreateConfiguration(target).setServiceClient((BlobServiceClient)BlobComponentConfigurer.property((CamelContext)camelContext, BlobServiceClient.class, (Object)value));
                return true;
            }
            case "timeout": {
                this.getOrCreateConfiguration(target).setTimeout((Duration)BlobComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("autoDiscoverClient", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("blobName", String.class);
        answer.put("blobOffset", Long.TYPE);
        answer.put("blobSequenceNumber", Long.class);
        answer.put("blobType", BlobType.class);
        answer.put("blockListType", BlockListType.class);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("closeStreamAfterRead", Boolean.TYPE);
        answer.put("closeStreamAfterWrite", Boolean.TYPE);
        answer.put("commitBlockListLater", Boolean.TYPE);
        answer.put("configuration", BlobConfiguration.class);
        answer.put("createAppendBlob", Boolean.TYPE);
        answer.put("createPageBlob", Boolean.TYPE);
        answer.put("credentials", StorageSharedKeyCredential.class);
        answer.put("dataCount", Long.class);
        answer.put("downloadLinkExpiration", Long.class);
        answer.put("fileDir", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maxResultsPerPage", Integer.class);
        answer.put("maxRetryRequests", Integer.TYPE);
        answer.put("operation", BlobOperationsDefinition.class);
        answer.put("pageBlobSize", Long.class);
        answer.put("prefix", String.class);
        answer.put("serviceClient", BlobServiceClient.class);
        answer.put("timeout", Duration.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        BlobComponent target = (BlobComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "blobname": 
            case "blobName": {
                return this.getOrCreateConfiguration(target).getBlobName();
            }
            case "bloboffset": 
            case "blobOffset": {
                return this.getOrCreateConfiguration(target).getBlobOffset();
            }
            case "blobsequencenumber": 
            case "blobSequenceNumber": {
                return this.getOrCreateConfiguration(target).getBlobSequenceNumber();
            }
            case "blobtype": 
            case "blobType": {
                return this.getOrCreateConfiguration(target).getBlobType();
            }
            case "blocklisttype": 
            case "blockListType": {
                return this.getOrCreateConfiguration(target).getBlockListType();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return this.getOrCreateConfiguration(target).isCloseStreamAfterRead();
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return this.getOrCreateConfiguration(target).isCloseStreamAfterWrite();
            }
            case "commitblocklistlater": 
            case "commitBlockListLater": {
                return this.getOrCreateConfiguration(target).isCommitBlockListLater();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "createappendblob": 
            case "createAppendBlob": {
                return this.getOrCreateConfiguration(target).isCreateAppendBlob();
            }
            case "createpageblob": 
            case "createPageBlob": {
                return this.getOrCreateConfiguration(target).isCreatePageBlob();
            }
            case "credentials": {
                return this.getOrCreateConfiguration(target).getCredentials();
            }
            case "datacount": 
            case "dataCount": {
                return this.getOrCreateConfiguration(target).getDataCount();
            }
            case "downloadlinkexpiration": 
            case "downloadLinkExpiration": {
                return this.getOrCreateConfiguration(target).getDownloadLinkExpiration();
            }
            case "filedir": 
            case "fileDir": {
                return this.getOrCreateConfiguration(target).getFileDir();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresultsperpage": 
            case "maxResultsPerPage": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerPage();
            }
            case "maxretryrequests": 
            case "maxRetryRequests": {
                return this.getOrCreateConfiguration(target).getMaxRetryRequests();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "pageblobsize": 
            case "pageBlobSize": {
                return this.getOrCreateConfiguration(target).getPageBlobSize();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "serviceclient": 
            case "serviceClient": {
                return this.getOrCreateConfiguration(target).getServiceClient();
            }
            case "timeout": {
                return this.getOrCreateConfiguration(target).getTimeout();
            }
        }
        return null;
    }
}

