/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobStorageException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.storage.blob.BlobEndpoint;
import org.apache.camel.component.azure.storage.blob.client.BlobClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperations;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;

public class BlobConsumer
extends ScheduledPollConsumer {
    public BlobConsumer(BlobEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        String containerName = this.getEndpoint().getConfiguration().getContainerName();
        String blobName = this.getEndpoint().getConfiguration().getBlobName();
        BlobServiceClient serviceClient = this.getEndpoint().getBlobServiceClient();
        BlobClientWrapper clientWrapper = new BlobClientWrapper(serviceClient.getBlobContainerClient(containerName).getBlobClient(blobName));
        BlobOperations operations = new BlobOperations(this.getEndpoint().getConfiguration(), clientWrapper);
        Exchange exchange = this.getEndpoint().createExchange();
        try {
            BlobOperationResponse response = !ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getFileDir()) ? operations.downloadBlobToFile(exchange) : operations.getBlob(exchange);
            this.getEndpoint().setResponseOnExchange(response, exchange);
            this.getAsyncProcessor().process(exchange);
            return 1;
        }
        catch (BlobStorageException ex) {
            if (404 == ex.getStatusCode()) {
                return 0;
            }
            throw ex;
        }
    }

    public BlobEndpoint getEndpoint() {
        return (BlobEndpoint)super.getEndpoint();
    }
}

