/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class BlobEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":accountName/containerName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "azure-storage-blob".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "accountName", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "containerName", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("blobName");
        props.add("accountName");
        props.add("credentials");
        props.add("prefix");
        props.add("createPageBlob");
        props.add("blobOffset");
        props.add("timeout");
        props.add("dataCount");
        props.add("blobServiceClient");
        props.add("maxRetryRequests");
        props.add("bridgeErrorHandler");
        props.add("containerName");
        props.add("closeStreamAfterRead");
        props.add("closeStreamAfterWrite");
        props.add("autoDiscoverClient");
        props.add("maxResultsPerPage");
        props.add("downloadLinkExpiration");
        props.add("exchangePattern");
        props.add("blockListType");
        props.add("createAppendBlob");
        props.add("regex");
        props.add("lazyStartProducer");
        props.add("blobSequenceNumber");
        props.add("accessKey");
        props.add("commitBlockListLater");
        props.add("serviceClient");
        props.add("fileDir");
        props.add("blobType");
        props.add("pageBlobSize");
        props.add("exceptionHandler");
        props.add("operation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

