/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.azure.storage.blob.BlobUtils;

public final class BlobStreamAndLength {
    private final InputStream inputStream;
    private final long streamLength;

    private BlobStreamAndLength(InputStream inputStream, long streamLength) {
        this.inputStream = inputStream;
        this.streamLength = streamLength;
    }

    public static BlobStreamAndLength createBlobStreamAndLengthFromExchangeBody(Exchange exchange) throws IOException {
        Object body = exchange.getIn().getBody();
        Long blobSize = (Long)exchange.getIn().getHeader("CamelAzureStorageBlobBlobUploadSize", () -> null, Long.class);
        exchange.getIn().removeHeader("CamelAzureStorageBlobBlobUploadSize");
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof InputStream) {
            return new BlobStreamAndLength((InputStream)body, blobSize != null ? blobSize : BlobUtils.getInputStreamLength((InputStream)body));
        }
        if (body instanceof File) {
            return new BlobStreamAndLength(new BufferedInputStream(new FileInputStream((File)body)), ((File)body).length());
        }
        if (body instanceof byte[]) {
            return new BlobStreamAndLength(new ByteArrayInputStream((byte[])body), ((byte[])body).length);
        }
        InputStream inputStream = (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, exchange, body);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unsupported blob type:" + body.getClass().getName());
        }
        return new BlobStreamAndLength(inputStream, blobSize != null ? blobSize : BlobUtils.getInputStreamLength(inputStream));
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getStreamLength() {
        return this.streamLength;
    }
}

