/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob;

import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import java.time.Duration;
import java.util.Map;

public class BlobCommonRequestOptions {
    private final BlobHttpHeaders blobHttpHeaders;
    private final Map<String, String> metadata;
    private final AccessTier accessTier;
    private final BlobRequestConditions blobRequestConditions;
    private final byte[] contentMD5;
    private final Duration timeout;

    public BlobCommonRequestOptions(BlobHttpHeaders blobHttpHeaders, Map<String, String> metadata, AccessTier accessTier, BlobRequestConditions blobRequestConditions, byte[] contentMD5, Duration timeout) {
        this.blobHttpHeaders = blobHttpHeaders;
        this.metadata = metadata;
        this.accessTier = accessTier;
        this.blobRequestConditions = blobRequestConditions;
        this.contentMD5 = contentMD5;
        this.timeout = timeout;
    }

    public BlobHttpHeaders getBlobHttpHeaders() {
        return this.blobHttpHeaders;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public <T extends BlobRequestConditions> T getBlobRequestConditions() {
        return (T)(this.blobRequestConditions == null ? null : this.blobRequestConditions);
    }

    public byte[] getContentMD5() {
        return this.contentMD5;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String leaseId() {
        return this.blobRequestConditions != null ? this.blobRequestConditions.getLeaseId() : null;
    }
}

