/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.datalake.DataLakeEndpoint;
import org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeDirectoryClientWrapper;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileClientWrapper;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileSystemClientWrapper;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeServiceClientWrapper;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeDirectoryOperations;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeFileOperations;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeFileSystemOperations;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeServiceOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLakeProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeProducer.class);
    private final DataLakeConfiguration configuration = this.getEndpoint().getConfiguration();
    private final DataLakeConfigurationOptionsProxy configurationProxy = new DataLakeConfigurationOptionsProxy(this.configuration);
    private final DataLakeServiceClientWrapper dataLakeServiceClientWrapper = new DataLakeServiceClientWrapper(this.getEndpoint().getDataLakeServiceClient());

    public DataLakeProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public DataLakeEndpoint getEndpoint() {
        return (DataLakeEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws IllegalArgumentException, IOException {
        DataLakeOperationsDefinition operation = this.determineOperation(exchange);
        switch (operation) {
            case listFileSystem: {
                this.setResponse(exchange, this.getServiceOperations(exchange).listFileSystems(exchange));
                break;
            }
            case createFileSystem: {
                this.setResponse(exchange, this.getFileSystemOperations(exchange).createFileSystem(exchange));
                break;
            }
            case deleteFileSystem: {
                this.setResponse(exchange, this.getFileSystemOperations(exchange).deleteFileSystem(exchange));
                break;
            }
            case listPaths: {
                this.setResponse(exchange, this.getFileSystemOperations(exchange).listPaths(exchange));
                break;
            }
            case getFile: {
                this.setResponse(exchange, this.getFileOperations(exchange).getFile(exchange));
                break;
            }
            case downloadToFile: {
                this.setResponse(exchange, this.getFileOperations(exchange).downloadToFile(exchange));
                break;
            }
            case downloadLink: {
                this.setResponse(exchange, this.getFileOperations(exchange).downloadLink(exchange));
                break;
            }
            case deleteFile: {
                this.setResponse(exchange, this.getFileOperations(exchange).deleteFile(exchange));
                break;
            }
            case appendToFile: {
                this.setResponse(exchange, this.getFileOperations(exchange).appendToFile(exchange));
                break;
            }
            case flushToFile: {
                this.setResponse(exchange, this.getFileOperations(exchange).flushToFile(exchange));
                break;
            }
            case uploadFromFile: {
                this.setResponse(exchange, this.getFileOperations(exchange).uploadFromFile(exchange));
                break;
            }
            case openQueryInputStream: {
                this.setResponse(exchange, this.getFileOperations(exchange).openQueryInputStream(exchange));
                break;
            }
            case upload: {
                this.setResponse(exchange, this.getFileOperations(exchange).upload(exchange));
                break;
            }
            case createFile: {
                this.setResponse(exchange, this.getDirectoryOperations(exchange).createFile(exchange));
                break;
            }
            case deleteDirectory: {
                this.setResponse(exchange, this.getDirectoryOperations(exchange).deleteDirectory(exchange));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void setResponse(Exchange exchange, DataLakeOperationResponse dataLakeOperationResponse) {
        exchange.getMessage().setBody(dataLakeOperationResponse.getBody());
        exchange.getMessage().setHeaders(dataLakeOperationResponse.getHeaders());
    }

    private DataLakeOperationsDefinition determineOperation(Exchange exchange) {
        return this.configurationProxy.getOperation(exchange);
    }

    private DataLakeServiceOperations getServiceOperations(Exchange exchange) {
        return new DataLakeServiceOperations(this.configuration, this.dataLakeServiceClientWrapper);
    }

    private DataLakeFileSystemOperations getFileSystemOperations(Exchange exchange) {
        DataLakeFileSystemClientWrapper clientWrapper = this.dataLakeServiceClientWrapper.getDataLakeFileSystemClientWrapper(this.determineFileSystemName(exchange));
        return new DataLakeFileSystemOperations(this.configuration, clientWrapper);
    }

    private DataLakeDirectoryOperations getDirectoryOperations(Exchange exchange) {
        DataLakeDirectoryClientWrapper clientWrapper = this.dataLakeServiceClientWrapper.getDataLakeFileSystemClientWrapper(this.determineFileSystemName(exchange)).getDataLakeDirectoryClientWrapper(this.determineDirectoryName(exchange));
        return new DataLakeDirectoryOperations(this.configuration, clientWrapper);
    }

    private DataLakeFileOperations getFileOperations(Exchange exchange) {
        DataLakeFileClientWrapper clientWrapper = this.dataLakeServiceClientWrapper.getDataLakeFileSystemClientWrapper(this.determineFileSystemName(exchange)).getDataLakeFileClientWrapper(this.determineFileName(exchange));
        return new DataLakeFileOperations(this.configuration, clientWrapper);
    }

    private String determineFileSystemName(Exchange exchange) {
        String fileSystemName = this.configurationProxy.getFileSystemName(exchange);
        if (ObjectHelper.isEmpty((Object)fileSystemName)) {
            throw new IllegalArgumentException("File system name must be specified.");
        }
        return fileSystemName;
    }

    private String determineDirectoryName(Exchange exchange) {
        String directoryName = this.configurationProxy.getDirectoryName(exchange);
        if (ObjectHelper.isEmpty((Object)directoryName)) {
            throw new IllegalArgumentException("Directory name must be specified");
        }
        return directoryName;
    }

    private String determineFileName(Exchange exchange) {
        String fileName = this.configurationProxy.getFileName(exchange);
        if (ObjectHelper.isEmpty((Object)fileName)) {
            throw new IllegalArgumentException("File name must be specified");
        }
        return fileName;
    }
}

