/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.identity.ClientSecretCredential;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="azure-storage-datalake")
public class DataLakeComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeComponent.class);
    @Metadata(description="configuration object for datalake")
    private DataLakeConfiguration configuration = new DataLakeConfiguration();

    public DataLakeComponent() {
    }

    public DataLakeComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().isEmpty()) {
            throw new IllegalArgumentException("At least the account name must be specified");
        }
        DataLakeConfiguration configuration = this.configuration != null ? this.configuration.copy() : new DataLakeConfiguration();
        String[] details = remaining.split("/");
        configuration.setAccountName(details[0]);
        if (details.length > 1) {
            configuration.setFileSystemName(details[1]);
        }
        DataLakeEndpoint endpoint = new DataLakeEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.setCredentialsFromRegistry(configuration);
        this.validateConfiguration(configuration);
        return endpoint;
    }

    public DataLakeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DataLakeConfiguration configuration) {
        this.configuration = configuration;
    }

    private void setCredentialsFromRegistry(DataLakeConfiguration configuration) {
        if (ObjectHelper.isEmpty((Object)configuration.getServiceClient())) {
            Set storageSharedKeyCredentials = this.getCamelContext().getRegistry().findByType(StorageSharedKeyCredential.class);
            Set clientSecretCredentials = this.getCamelContext().getRegistry().findByType(ClientSecretCredential.class);
            if (storageSharedKeyCredentials.size() == 1) {
                configuration.setSharedKeyCredential((StorageSharedKeyCredential)storageSharedKeyCredentials.stream().findFirst().get());
            }
            if (clientSecretCredentials.size() == 1) {
                configuration.setClientSecretCredential((ClientSecretCredential)clientSecretCredentials.stream().findFirst().get());
            }
        }
    }

    private void validateConfiguration(DataLakeConfiguration config) {
        if (config.getServiceClient() == null && config.getClientSecretCredential() == null && config.getSharedKeyCredential() == null) {
            throw new IllegalArgumentException("client or credentials must be specified");
        }
    }
}

