/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import org.apache.camel.spi.Metadata;

public final class DataLakeConstants {
    private static final String HEADER_PREFIX = "CamelAzureStorageDataLake";
    @Metadata(label="from user", description="Defines options available to configure the behavior of a call to listFileSystemsSegment on a DataLakeServiceAsyncClient object. Null may be passed.", javaType="ListFileSystemsOptions")
    public static final String LIST_FILESYSTEMS_OPTIONS = "CamelAzureStorageDataLakeListFileSystemsOptions";
    @Metadata(label="from user", description="An optional timeout value beyond which a RuntimeException will be raised.", javaType="Duration")
    public static final String TIMEOUT = "CamelAzureStorageDataLakeTimeout";
    @Metadata(label="from user", description="Specify the producer operation to execute. Different operations allowed are shown below.", javaType="org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition")
    public static final String DATALAKE_OPERATION = "CamelAzureStorageDataLakeOperation";
    @Metadata(label="from user", description="Name of the file system in azure datalake on which operation is to be performed. Please make sure that filesystem name is all lowercase.", javaType="String")
    public static final String FILESYSTEM_NAME = "CamelAzureStorageDataLakeFileSystemName";
    @Metadata(label="from user", description="Name of the directory in azure datalake on which operation is to be performed.", javaType="String")
    public static final String DIRECTORY_NAME = "CamelAzureStorageDataLakeDirectoryName";
    @Metadata(label="from user", description="Name of the file in azure datalake on which operation is to be performed.", javaType="String")
    public static final String FILE_NAME = "CamelAzureStorageDataLakeFileName";
    @Metadata(label="from both", description="The metadata to associate with the file.", javaType="Map<String, String>")
    public static final String METADATA = "CamelAzureStorageDataLakeMetadata";
    @Metadata(label="from user", description="Defines options available to configure the behavior of a call to listFileSystemsSegment on a DataLakeServiceAsyncClient object.", javaType="PublicAccessType")
    public static final String PUBLIC_ACCESS_TYPE = "CamelAzureStorageDataLakePublicAccessType";
    @Metadata(label="from component", description="Non parsed http headers that can be used by the user.", javaType="HttpHeaders")
    public static final String RAW_HTTP_HEADERS = "CamelAzureStorageDataLakeRawHttpHeaders";
    @Metadata(label="from user", description="This contains values which will restrict the successful operation of a variety of requests to the conditions present. These conditions are entirely optional.", javaType="DataLakeRequestConditions")
    public static final String DATALAKE_REQUEST_CONDITION = "CamelAzureStorageDataLakeRequestCondition";
    @Metadata(label="from user", description="Defines options available to configure the behavior of a call to listContainersSegment on a DataLakeFileSystemClient object. Null may be passed.", javaType="ListPathOptions")
    public static final String LIST_PATH_OPTIONS = "CamelAzureStorageDataLakeListPathOptions";
    @Metadata(label="from user", description="Path of the file to be used for upload operations.", javaType="String")
    public static final String PATH = "CamelAzureStorageDataLakePath";
    @Metadata(label="from user", description="Specifies if the call to listContainersSegment should recursively include all paths.", javaType="Boolean")
    public static final String RECURSIVE = "CamelAzureStorageDataLakeRecursive";
    @Metadata(label="from user", description="Specifies the maximum number of blobs to return, including all BlobPrefix elements.", javaType="Integer")
    public static final String MAX_RESULTS = "CamelAzureStorageDataLakeMaxResults";
    @Metadata(label="from user", description="Specifies if the name of the user principal should be returned.", javaType="Boolean")
    public static final String USER_PRINCIPAL_NAME_RETURNED = "CamelAzureStorageDataLakeUserPrincipalNameReturned";
    @Metadata(label="from user", description="Filter the results to return only those files with match the specified regular expression.", javaType="String")
    public static final String REGEX = "CamelAzureStorageDataLakeRegex";
    @Metadata(label="from user", description="Directory in which the file is to be downloaded.", javaType="String")
    public static final String FILE_DIR = "CamelAzureStorageDataLakeFileDir";
    @Metadata(label="from component", description="Access tier of file.", javaType="AccessTier")
    public static final String ACCESS_TIER = "CamelAzureStorageDataLakeAccessTier";
    @Metadata(label="from user", description="An MD5 hash of the content. The hash is used to verify the integrity of the file during transport.", javaType="byte[]")
    public static final String CONTENT_MD5 = "CamelAzureStorageDataLakeContentMD5";
    @Metadata(label="from user", description="This is a representation of a range of bytes on a file, typically used during a download operation. Passing null as a FileRange value will default to the entire range of the file.", javaType="FileRange")
    public static final String FILE_RANGE = "CamelAzureStorageDataLakeFileRange";
    @Metadata(label="from user", description="The configuration used to parallelize data transfer operations.", javaType="ParallelTransferOptions")
    public static final String PARALLEL_TRANSFER_OPTIONS = "CamelAzureStorageDataLakeParallelTransferOptions";
    @Metadata(label="from user", description="Set of OpenOption used to configure how to open or create a file.", javaType="Set<OpenOption>")
    public static final String OPEN_OPTIONS = "CamelAzureStorageDataLakeOpenOptions";
    @Metadata(label="from component", description="Datetime when the access tier of the blob last changed.", javaType="OffsetDateTime")
    public static final String ACCESS_TIER_CHANGE_TIME = "CamelAzureStorageDataLakeAccessTierChangeTime";
    @Metadata(label="from component", description="Archive status of file.", javaType="ArchiveStatus")
    public static final String ARCHIVE_STATUS = "CamelAzureStorageDataLakeArchiveStatus";
    @Metadata(label="from component", description="Cache control specified for the file.", javaType="String")
    public static final String CACHE_CONTROL = "CamelAzureStorageDataLakeCacheControl";
    @Metadata(label="from component", description="Content disposition specified for the file.", javaType="String")
    public static final String CONTENT_DISPOSITION = "CamelAzureStorageDataLakeContentDisposition";
    @Metadata(label="from component", description="Content encoding specified for the file.", javaType="String")
    public static final String CONTENT_ENCODING = "CamelAzureStorageDataLakeContentEncoding";
    @Metadata(label="from component", description="Content language specified for the file.", javaType="String")
    public static final String CONTENT_LANGUAGE = "CamelAzureStorageDataLakeContentLanguage";
    @Metadata(label="from component", description="Content type specified for the file.", javaType="String")
    public static final String CONTENT_TYPE = "CamelAzureStorageDataLakeContentType";
    @Metadata(label="from component", description="Conclusion time of the last attempted Copy Blob operation where this file was the destination file.", javaType="OffsetDateTime")
    public static final String COPY_COMPLETION_TIME = "CamelAzureStorageDataLakeCopyCompletionTime";
    @Metadata(label="from component", description="String identifier for this copy operation.", javaType="String")
    public static final String COPY_ID = "CamelAzureStorageDataLakeCopyId";
    @Metadata(label="from component", description="Contains the number of bytes copied and the total bytes in the source in the last attempted Copy Blob operation where this file was the destination file.", javaType="String")
    public static final String COPY_PROGRESS = "CamelAzureStorageDataLakeCopyProgress";
    @Metadata(label="from component", description="URL up to 2 KB in length that specifies the source file or file used in the last attempted Copy Blob operation where this file was the destination file.", javaType="String")
    public static final String COPY_SOURCE = "CamelAzureStorageDataLakeCopySource";
    @Metadata(label="from component", description="Status of the last copy operation performed on the file.", javaType="com.azure.storage.file.datalake.models.CopyStatusType")
    public static final String COPY_STATUS = "CamelAzureStorageDataLakeCopyStatus";
    @Metadata(label="from component", description="The description of the copy's status", javaType="String")
    public static final String COPY_STATUS_DESCRIPTION = "CamelAzureStorageDataLakeCopyStatusDescription";
    @Metadata(label="from component", description="Creation time of the file.", javaType="OffsetDateTime")
    public static final String CREATION_TIME = "CamelAzureStorageDataLakeCreationTime";
    @Metadata(label="from component", description="The SHA-256 hash of the encryption key used to encrypt the file.", javaType="String")
    public static final String ENCRYPTION_KEY_SHA_256 = "CamelAzureStorageDataLakeEncryptionKeySha256";
    @Metadata(label="from component", description="The E Tag of the file.", javaType="String")
    public static final String E_TAG = "CamelAzureStorageDataLakeETag";
    @Metadata(label="from component", description="Size of the file.", javaType="Long")
    public static final String FILE_SIZE = "CamelAzureStorageDataLakeFileSize";
    @Metadata(label="from component", description="Datetime when the file was last modified.", javaType="OffsetDateTime")
    public static final String LAST_MODIFIED = "CamelAzureStorageDataLakeLastModified";
    @Metadata(label="from component", description="Type of lease on the file.", javaType="com.azure.storage.file.datalake.models.LeaseDurationType")
    public static final String LEASE_DURATION = "CamelAzureStorageDataLakeLeaseDuration";
    @Metadata(label="from component", description="State of the lease on the file.", javaType="com.azure.storage.file.datalake.models.LeaseStateType")
    public static final String LEASE_STATE = "CamelAzureStorageDataLakeLeaseState";
    @Metadata(label="from component", description="Status of the lease on the file.", javaType="com.azure.storage.file.datalake.models.LeaseStatusType")
    public static final String LEASE_STATUS = "CamelAzureStorageDataLakeLeaseStatus";
    @Metadata(label="from user", description="Flag indicating if the file was incrementally copied.", javaType="Boolean")
    public static final String INCREMENTAL_COPY = "CamelAzureStorageDataLakeIncrementalCopy";
    @Metadata(label="from component", description="Flag indicating if the file's content is encrypted on the server.", javaType="Boolean")
    public static final String SERVER_ENCRYPTED = "CamelAzureStorageDataLakeServerEncrypted";
    @Metadata(label="from user", description="Set the Expiration time of the download link.", javaType="Long")
    public static final String DOWNLOAD_LINK_EXPIRATION = "CamelAzureStorageDataLakeDownloadLinkExpiration";
    @Metadata(label="from component", description="The link that can be used to download the file from datalake.", javaType="String")
    public static final String DOWNLOAD_LINK = "CamelAzureStorageDataLakeDownloadLink";
    @Metadata(label="from user", description="The position where the data is to be appended.", javaType="Long")
    public static final String FILE_OFFSET = "CamelAzureStorageDataLakeFileOffset";
    @Metadata(label="from user", description="By setting lease id, requests will fail if the provided lease does not match the active lease on the file.", javaType="String")
    public static final String LEASE_ID = "CamelAzureStorageDataLakeLeaseId";
    @Metadata(label="from user", description="Additional parameters for a set of operations.", javaType="PathHttpHeaders")
    public static final String PATH_HTTP_HEADERS = "CamelAzureStorageDataLakePathHttpHeaders";
    @Metadata(label="from user", description="Determines Whether or not uncommitted data is to be retained after the operation.", javaType="Boolean")
    public static final String RETAIN_UNCOMMITED_DATA = "CamelAzureStorageDataLakeRetainCommitedData";
    @Metadata(label="from user", description="Whether or not a file changed event raised indicates completion (true) or modification (false).", javaType="Boolean")
    public static final String CLOSE = "CamelAzureStorageDataLakeClose";
    @Metadata(label="from user", description="The length of the file after all data has been written.", javaType="Long")
    public static final String POSITION = "CamelAzureStorageDataLakePosition";
    @Metadata(label="from user", description="The query expression on the file.", javaType="String")
    public static final String EXPRESSION = "CamelAzureStorageDataLakeExpression";
    @Metadata(label="from user", description="Defines the input serialization for a file query request. either FileQueryJsonSerialization or FileQueryDelimitedSerialization", javaType="FileQuerySerialization")
    public static final String INPUT_SERIALIZATION = "CamelAzureStorageDataLakeInputSerialization";
    @Metadata(label="from user", description="Defines the output serialization for a file query request. either FileQueryJsonSerialization or FileQueryDelimitedSerialization", javaType="FileQuerySerialization")
    public static final String OUTPUT_SERIALIZATION = "CamelAzureStorageDataLakeOutputSerialization";
    @Metadata(label="from user", description="Sets error consumer for file query", javaType="Consumer<FileQueryError>")
    public static final String ERROR_CONSUMER = "CamelAzureStorageDataLakeErrorConsumer";
    @Metadata(label="from user", description="Sets progress consumer for file query", javaType="Consumer<FileQueryProgress>")
    public static final String PROGRESS_CONSUMER = "CamelAzureStorageDataLakeProgressConsumer";
    @Metadata(label="from user", description="Optional parameters for File Query.", javaType="FileQueryOptions")
    public static final String QUERY_OPTIONS = "CamelAzureStorageDataLakeQueryOptions";
    @Metadata(label="from user", description="Sets the permission for file.", javaType="String")
    public static final String PERMISSION = "CamelAzureStorageDataLakePermission";
    @Metadata(label="from user", description="Sets the umask for file.", javaType="String")
    public static final String UMASK = "CamelAzureStorageDataLakeUmask";

    private DataLakeConstants() {
    }
}

