/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.storage.file.datalake.DataLakeServiceClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConsumer;
import org.apache.camel.component.azure.storage.datalake.DataLakeProducer;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeClientFactory;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.8.0", scheme="azure-storage-datalake", title="Azure storage datalake service", syntax="azure-storage-datalake:accountName/fileSystemName", category={Category.CLOUD, Category.FILE})
public class DataLakeEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeEndpoint.class);
    @UriParam(description="service client of datalake")
    private DataLakeServiceClient dataLakeServiceClient;
    @UriParam(description="configuration object of azure datalake")
    private DataLakeConfiguration configuration;

    public DataLakeEndpoint() {
    }

    public DataLakeEndpoint(String uri, Component component, DataLakeConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new DataLakeProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new DataLakeConsumer((Endpoint)this, processor);
    }

    public DataLakeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DataLakeConfiguration configuration) {
        this.configuration = configuration;
    }

    public DataLakeServiceClient getDataLakeServiceClient() {
        return this.dataLakeServiceClient;
    }

    public void setDataLakeServiceClient(DataLakeServiceClient dataLakeServiceClient) {
        this.dataLakeServiceClient = dataLakeServiceClient;
    }

    public void setResponseOnExchange(DataLakeOperationResponse response, Exchange exchange) {
        Message message = exchange.getIn();
        message.setBody(response.getBody());
        message.setHeaders(response.getHeaders());
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.dataLakeServiceClient = this.configuration.getServiceClient() != null ? this.configuration.getServiceClient() : DataLakeClientFactory.createDataLakeServiceClient(this.configuration);
    }
}

