/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.operations;

import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.models.PublicAccessType;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.datalake.DataLakeExchangeHeaders;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeFileSystemClientWrapper;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLakeFileSystemOperations {
    private static final Logger LOG = LoggerFactory.getLogger(DataLakeFileSystemOperations.class);
    private final DataLakeFileSystemClientWrapper client;
    private final DataLakeConfigurationOptionsProxy configurationProxy;

    public DataLakeFileSystemOperations(DataLakeConfiguration configuration, DataLakeFileSystemClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
        this.configurationProxy = new DataLakeConfigurationOptionsProxy(configuration);
    }

    public DataLakeOperationResponse createFileSystem(Exchange exchange) {
        LOG.info("inside create file system in operation");
        Map<String, String> metadata = this.configurationProxy.getMetadata(exchange);
        PublicAccessType publicAccessType = this.configurationProxy.getPublicAccessType(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        DataLakeExchangeHeaders dataLakeExchangeHeaders = new DataLakeExchangeHeaders().httpHeaders(this.client.createFileSystem(metadata, publicAccessType, timeout));
        LOG.info(dataLakeExchangeHeaders.toString());
        return new DataLakeOperationResponse(true, dataLakeExchangeHeaders.toMap());
    }

    public DataLakeOperationResponse deleteFileSystem(Exchange exchange) {
        DataLakeRequestConditions dataLakeRequestConditions = this.configurationProxy.getDataLakeRequestConditions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        DataLakeExchangeHeaders dataLakeExchangeHeaders = new DataLakeExchangeHeaders().httpHeaders(this.client.deleteFileSystem(dataLakeRequestConditions, timeout));
        return new DataLakeOperationResponse(true, dataLakeExchangeHeaders.toMap());
    }

    public DataLakeOperationResponse listPaths(Exchange exchange) {
        ListPathsOptions listPathsOptions = this.configurationProxy.getListPathOptions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        String regex = this.configurationProxy.getRegex(exchange);
        List<PathItem> paths = this.client.listPaths(listPathsOptions, timeout);
        if (ObjectHelper.isEmpty((Object)regex)) {
            return new DataLakeOperationResponse(paths);
        }
        List filteredPaths = paths.stream().filter(x -> x.getName().matches(regex)).collect(Collectors.toCollection(LinkedList::new));
        return new DataLakeOperationResponse(filteredPaths);
    }
}

