/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.storage.datalake.CredentialType;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="azure-storage-datalake")
public class DataLakeComponent
extends HealthCheckComponent {
    @Metadata(description="configuration object for data lake")
    private DataLakeConfiguration configuration = new DataLakeConfiguration();

    public DataLakeComponent() {
    }

    public DataLakeComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("At least the account name must be specified");
        }
        DataLakeConfiguration configuration = this.configuration != null ? this.configuration.copy() : new DataLakeConfiguration();
        String[] details = remaining.split("/");
        configuration.setAccountName(details[0]);
        if (details.length > 1) {
            configuration.setFileSystemName(details[1]);
        }
        DataLakeEndpoint endpoint = new DataLakeEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getServiceClient())) {
            if (configuration.getSharedKeyCredential() == null && configuration.getSasCredential() == null && configuration.getClientSecretCredential() == null) {
                if (configuration.getCredentialType() == null) {
                    configuration.setCredentialType(CredentialType.CLIENT_SECRET);
                }
            } else if (configuration.getSharedKeyCredential() != null) {
                configuration.setCredentialType(CredentialType.SHARED_KEY_CREDENTIAL);
            } else if (configuration.getSasCredential() != null) {
                configuration.setCredentialType(CredentialType.AZURE_SAS);
            } else if (configuration.getClientSecretCredential() != null) {
                configuration.setCredentialType(CredentialType.CLIENT_SECRET);
            }
        }
        return endpoint;
    }

    public DataLakeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DataLakeConfiguration configuration) {
        this.configuration = configuration;
    }
}

