/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.operations;

import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.datalake.client.DataLakeServiceClientWrapper;
import org.apache.camel.component.azure.storage.datalake.operations.DataLakeOperationResponse;

public class DataLakeServiceOperations {
    private final DataLakeServiceClientWrapper client;
    private final DataLakeConfigurationOptionsProxy configurationProxy;

    public DataLakeServiceOperations(DataLakeConfiguration configuration, DataLakeServiceClientWrapper client) {
        this.client = client;
        this.configurationProxy = new DataLakeConfigurationOptionsProxy(configuration);
    }

    public DataLakeOperationResponse listFileSystems(Exchange exchange) {
        ListFileSystemsOptions listFileSystemsOptions = this.configurationProxy.getListFileSystemOptions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        return new DataLakeOperationResponse(this.client.listFileSystems(listFileSystemsOptions, timeout));
    }
}

