/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="azure-storage-queue")
public class QueueComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(QueueComponent.class);
    @Metadata
    private QueueConfiguration configuration = new QueueConfiguration();

    public QueueComponent() {
    }

    public QueueComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("At least the account name must be specified.");
        }
        QueueConfiguration configuration = this.configuration != null ? this.configuration.copy() : new QueueConfiguration();
        String[] parts = remaining.split("/");
        configuration.setAccountName(parts[0]);
        if (parts.length > 1) {
            configuration.setQueueName(parts[1]);
        }
        QueueEndpoint endpoint = new QueueEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        this.checkCredentials(configuration);
        this.validateConfigurations(configuration);
        return endpoint;
    }

    public QueueConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(QueueConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkCredentials(QueueConfiguration configuration) {
        Set storageSharedKeyCredentials;
        QueueServiceClient client = configuration.getServiceClient();
        if (client == null && (storageSharedKeyCredentials = this.getCamelContext().getRegistry().findByType(StorageSharedKeyCredential.class)).size() == 1) {
            configuration.setCredentials((StorageSharedKeyCredential)storageSharedKeyCredentials.stream().findFirst().get());
        }
    }

    private void checkAndSetRegistryClient(QueueConfiguration configuration, QueueEndpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getServiceClient())) {
            LOG.debug("Looking for an QueueServiceClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(QueueServiceClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one QueueServiceClient instance in the registry");
                configuration.setServiceClient((QueueServiceClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No QueueServiceClient instance in the registry");
            }
        } else {
            LOG.debug("QueueServiceClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }

    private void validateConfigurations(QueueConfiguration configuration) {
        if (configuration.getServiceClient() == null && configuration.getAccessKey() == null && configuration.getCredentials() == null) {
            throw new IllegalArgumentException("Azure Storage accessKey or QueueServiceClient must be specified.");
        }
    }
}

