/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueEndpoint;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.component.azure.storage.queue.client.QueueServiceClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperationResponse;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperations;
import org.apache.camel.component.azure.storage.queue.operations.QueueServiceOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class QueueProducer
extends DefaultProducer {
    private final QueueConfiguration configuration = this.getEndpoint().getConfiguration();
    private final QueueServiceClientWrapper queueServiceClientWrapper = new QueueServiceClientWrapper(this.getEndpoint().getQueueServiceClient());
    private final QueueServiceOperations queueServiceOperations = new QueueServiceOperations(this.queueServiceClientWrapper);

    public QueueProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        QueueOperationDefinition operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = QueueOperationDefinition.sendMessage;
        }
        switch (operation) {
            case listQueues: {
                this.setResponse(exchange, this.queueServiceOperations.listQueues(exchange));
                break;
            }
            case createQueue: {
                this.setResponse(exchange, this.getQueueOperations(exchange).createQueue(exchange));
                break;
            }
            case deleteQueue: {
                this.setResponse(exchange, this.getQueueOperations(exchange).deleteQueue(exchange));
                break;
            }
            case clearQueue: {
                this.setResponse(exchange, this.getQueueOperations(exchange).clearQueue(exchange));
                break;
            }
            case sendMessage: {
                this.setResponse(exchange, this.getQueueOperations(exchange).sendMessage(exchange));
                break;
            }
            case deleteMessage: {
                this.setResponse(exchange, this.getQueueOperations(exchange).deleteMessage(exchange));
                break;
            }
            case peekMessages: {
                this.setResponse(exchange, this.getQueueOperations(exchange).peekMessages(exchange));
                break;
            }
            case updateMessage: {
                this.setResponse(exchange, this.getQueueOperations(exchange).updateMessage(exchange));
                break;
            }
            case receiveMessages: {
                this.setResponse(exchange, this.getQueueOperations(exchange).receiveMessages(exchange));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    public QueueEndpoint getEndpoint() {
        return (QueueEndpoint)super.getEndpoint();
    }

    private void setResponse(Exchange exchange, QueueOperationResponse response) {
        exchange.getMessage().setBody(response.getBody());
        exchange.getMessage().setHeaders(response.getHeaders());
    }

    private QueueOperationDefinition determineOperation(Exchange exchange) {
        QueueOperationDefinition operation = QueueExchangeHeaders.getQueueOperationsDefinitionFromHeaders(exchange);
        if (operation != null) {
            return operation;
        }
        return this.configuration.getOperation();
    }

    private QueueOperations getQueueOperations(Exchange exchange) {
        return new QueueOperations(this.configuration, this.queueServiceClientWrapper.getQueueClientWrapper(this.determineQueueName(exchange)));
    }

    private String determineQueueName(Exchange exchange) {
        String queueName;
        String string = queueName = ObjectHelper.isEmpty((Object)QueueExchangeHeaders.getQueueNameFromHeaders(exchange)) ? this.configuration.getQueueName() : QueueExchangeHeaders.getQueueNameFromHeaders(exchange);
        if (ObjectHelper.isEmpty((Object)queueName)) {
            throw new IllegalArgumentException("Queue name must be specified");
        }
        return queueName;
    }
}

