/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.models.QueueMessageItem;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueConsumer;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.QueueProducer;
import org.apache.camel.component.azure.storage.queue.client.QueueClientFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.3.0", scheme="azure-storage-queue", title="Azure Storage Queue Service", syntax="azure-storage-queue:accountName/queueName", category={Category.CLOUD, Category.MESSAGING})
public class QueueEndpoint
extends DefaultEndpoint {
    private QueueServiceClient queueServiceClient;
    @UriParam
    private QueueConfiguration configuration;

    public QueueEndpoint(String uri, Component component, QueueConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new QueueProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getQueueName())) {
            throw new IllegalArgumentException("QueueName must be set.");
        }
        return new QueueConsumer(this, processor);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.queueServiceClient = this.configuration.getServiceClient() != null ? this.configuration.getServiceClient() : QueueClientFactory.createQueueServiceClient(this.configuration);
    }

    public Exchange createExchange(QueueMessageItem messageItem) {
        Exchange exchange = this.createExchange();
        Message message = exchange.getIn();
        message.setBody((Object)messageItem.getMessageText());
        message.setHeaders(QueueExchangeHeaders.createQueueExchangeHeadersFromQueueMessageItem(messageItem).toMap());
        return exchange;
    }

    public QueueConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(QueueConfiguration configuration) {
        this.configuration = configuration;
    }

    public QueueServiceClient getQueueServiceClient() {
        return this.queueServiceClient;
    }
}

