/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.operations;

import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.client.QueueServiceClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class QueueServiceOperations {
    private QueueServiceClientWrapper client;

    public QueueServiceOperations(QueueServiceClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client can not be null.");
        this.client = client;
    }

    public QueueOperationResponse listQueues(Exchange exchange) {
        if (exchange == null) {
            return new QueueOperationResponse(this.client.listQueues(null, null));
        }
        QueuesSegmentOptions segmentOptions = QueueExchangeHeaders.getQueuesSegmentOptionsFromHeaders(exchange);
        Duration timeout = QueueExchangeHeaders.getTimeoutFromHeaders(exchange);
        return new QueueOperationResponse(this.client.listQueues(segmentOptions, timeout));
    }
}

