/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class QueueEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":accountName/queueName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "azure-storage-queue".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "accountName", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "queueName", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(19);
        props.add("autoDiscoverClient");
        props.add("accountName");
        props.add("credentials");
        props.add("synchronous");
        props.add("maxMessages");
        props.add("exchangePattern");
        props.add("messageId");
        props.add("popReceipt");
        props.add("timeout");
        props.add("visibilityTimeout");
        props.add("timeToLive");
        props.add("lazyStartProducer");
        props.add("queueName");
        props.add("bridgeErrorHandler");
        props.add("accessKey");
        props.add("serviceClient");
        props.add("createQueue");
        props.add("exceptionHandler");
        props.add("operation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

