/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.time.Duration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class QueueConfiguration
implements Cloneable {
    @UriPath
    private String accountName;
    @UriPath
    private String queueName;
    @UriParam(label="security")
    private StorageSharedKeyCredential credentials;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="common")
    private QueueServiceClient serviceClient;
    @UriParam(label="common", defaultValue="true")
    private boolean autoDiscoverClient = true;
    @UriParam(label="producer")
    private QueueOperationDefinition operation = QueueOperationDefinition.sendMessage;
    @UriParam(label="producer", defaultValue="true")
    private boolean createQueue = true;
    @UriParam(label="queue")
    private Duration timeToLive;
    @UriParam(label="queue")
    private Duration visibilityTimeout;
    @UriParam(label="queue", defaultValue="1")
    private Integer maxMessages = 1;
    @UriParam(label="queue")
    private Duration timeout;
    @UriParam(label="queue")
    private String messageId;
    @UriParam(label="queue")
    private String popReceipt;

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public StorageSharedKeyCredential getCredentials() {
        return this.credentials;
    }

    public void setCredentials(StorageSharedKeyCredential credentials) {
        this.credentials = credentials;
    }

    public QueueServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public void setServiceClient(QueueServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Duration getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public void setVisibilityTimeout(Duration visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    public QueueOperationDefinition getOperation() {
        return this.operation;
    }

    public void setOperation(QueueOperationDefinition operation) {
        this.operation = operation;
    }

    public boolean isCreateQueue() {
        return this.createQueue;
    }

    public void setCreateQueue(boolean createQueue) {
        this.createQueue = createQueue;
    }

    public Integer getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(Integer maxMessages) {
        this.maxMessages = maxMessages;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getPopReceipt() {
        return this.popReceipt;
    }

    public void setPopReceipt(String popReceipt) {
        this.popReceipt = popReceipt;
    }

    public boolean isAutoDiscoverClient() {
        return this.autoDiscoverClient;
    }

    public void setAutoDiscoverClient(boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public QueueConfiguration copy() {
        try {
            return (QueueConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

