/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueStorageException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueEndpoint;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.client.QueueClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperations;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(QueueConsumer.class);
    private final QueueClientWrapper clientWrapper = new QueueClientWrapper(this.getServiceClient().getQueueClient(this.getConfiguration().getQueueName()));
    private final QueueOperations queueOperations = new QueueOperations(this.getConfiguration(), this.clientWrapper);

    public QueueConsumer(QueueEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        try {
            List<QueueMessageItem> messageItems = this.clientWrapper.receiveMessages(this.getConfiguration().getMaxMessages(), this.getConfiguration().getVisibilityTimeout(), this.getConfiguration().getTimeout());
            LOG.trace("Receiving messages [{}]...", messageItems);
            Queue<Exchange> exchanges = this.createExchanges(messageItems);
            return this.processBatch(CastUtils.cast(exchanges));
        }
        catch (QueueStorageException ex) {
            if (404 == ex.getStatusCode()) {
                return 0;
            }
            throw ex;
        }
    }

    private Queue<Exchange> createExchanges(List<QueueMessageItem> messageItems) {
        return messageItems.stream().map(queueMessageItem -> this.getEndpoint().createExchange((QueueMessageItem)queueMessageItem)).collect(Collectors.toCollection(LinkedList::new));
    }

    private QueueServiceClient getServiceClient() {
        return this.getEndpoint().getQueueServiceClient();
    }

    private QueueConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public QueueEndpoint getEndpoint() {
        return (QueueEndpoint)super.getEndpoint();
    }

    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            final String messageId = (String)exchange.getIn().getHeader("CamelAzureStorageQueueMessageId", String.class);
            final String popReceipt = (String)exchange.getIn().getHeader("CamelAzureStorageQueuePopReceipt", String.class);
            final Duration timeout = (Duration)exchange.getIn().getHeader("CamelAzureStorageQueueTimeout", Duration.class);
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    exchange.getIn().setHeader("CamelAzureStorageQueueMessageId", (Object)messageId);
                    exchange.getIn().setHeader("CamelAzureStorageQueuePopReceipt", (Object)popReceipt);
                    exchange.getIn().setHeader("CamelAzureStorageQueueTimeout", (Object)timeout);
                    QueueConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    QueueConsumer.this.processRollback(exchange);
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getAsyncProcessor().process(exchange, doneSync -> LOG.trace("Processing exchange [{}] done.", (Object)exchange));
        }
        return total;
    }

    private void processCommit(Exchange exchange) {
        try {
            LOG.trace("Deleting message with pop receipt handle {}...", (Object)QueueExchangeHeaders.getPopReceiptFromHeaders(exchange));
            this.queueOperations.deleteMessage(exchange);
        }
        catch (QueueStorageException ex) {
            this.getExceptionHandler().handleException("Error occurred during deleting message. This exception is ignored.", exchange, (Throwable)ex);
        }
    }

    private void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            this.getExceptionHandler().handleException("Error during processing exchange. Will attempt to process the message on next poll.", exchange, (Throwable)cause);
        }
    }
}

