/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.operations;

import com.azure.core.http.rest.Response;
import com.azure.storage.queue.models.UpdateMessageResult;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;
import org.apache.camel.component.azure.storage.queue.client.QueueClientWrapper;
import org.apache.camel.component.azure.storage.queue.operations.QueueOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class QueueOperations {
    public static final String MISSING_EXCHANGE = "exchange cannot be null";
    private final QueueConfigurationOptionsProxy configurationOptionsProxy;
    private final QueueClientWrapper client;

    public QueueOperations(QueueConfiguration configuration, QueueClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client can not be null.");
        this.client = client;
        this.configurationOptionsProxy = new QueueConfigurationOptionsProxy(configuration);
    }

    public QueueOperationResponse createQueue(Exchange exchange) {
        if (exchange == null) {
            return this.buildResponseWithEmptyBody(this.client.create(null, this.configurationOptionsProxy.getTimeout(null)));
        }
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.create(metadata, timeout));
    }

    public QueueOperationResponse clearQueue(Exchange exchange) {
        if (exchange == null) {
            return this.buildResponseWithEmptyBody(this.client.clearMessages(this.configurationOptionsProxy.getTimeout(null)));
        }
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.clearMessages(timeout));
    }

    public QueueOperationResponse deleteQueue(Exchange exchange) {
        if (exchange == null) {
            return this.buildResponseWithEmptyBody(this.client.delete(this.configurationOptionsProxy.getTimeout(null)));
        }
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.delete(timeout));
    }

    public QueueOperationResponse sendMessage(Exchange exchange) {
        ObjectHelper.notNull((Object)exchange, (String)MISSING_EXCHANGE);
        boolean queueCreated = this.configurationOptionsProxy.isCreateQueue(exchange);
        if (queueCreated) {
            this.createQueue(exchange);
        }
        String text = (String)exchange.getIn().getBody(String.class);
        Duration visibilityTimeout = this.configurationOptionsProxy.getVisibilityTimeout(exchange);
        Duration timeToLive = this.configurationOptionsProxy.getTimeToLive(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return this.buildResponseWithEmptyBody(this.client.sendMessage(text, visibilityTimeout, timeToLive, timeout));
    }

    public QueueOperationResponse deleteMessage(Exchange exchange) {
        ObjectHelper.notNull((Object)exchange, (String)MISSING_EXCHANGE);
        String messageId = this.configurationOptionsProxy.getMessageId(exchange);
        String popReceipt = this.configurationOptionsProxy.getPopReceipt(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        if (ObjectHelper.isEmpty((String)messageId)) {
            throw new IllegalArgumentException(String.format("Message ID must be specified in camel headers '%s' for deleteMessage operation.", "CamelAzureStorageQueueMessageId"));
        }
        if (ObjectHelper.isEmpty((String)popReceipt)) {
            throw new IllegalArgumentException(String.format("Message Pop Receipt must be specified in camel headers '%s' for deleteMessage operation.", "CamelAzureStorageQueuePopReceipt"));
        }
        return this.buildResponseWithEmptyBody(this.client.deleteMessage(messageId, popReceipt, timeout));
    }

    public QueueOperationResponse receiveMessages(Exchange exchange) {
        if (exchange == null) {
            return QueueOperationResponse.create(this.client.receiveMessages(this.configurationOptionsProxy.getMaxMessages(null), this.configurationOptionsProxy.getVisibilityTimeout(null), this.configurationOptionsProxy.getTimeout(null)));
        }
        Integer maxMessages = this.configurationOptionsProxy.getMaxMessages(exchange);
        Duration visibilityTimeout = this.configurationOptionsProxy.getVisibilityTimeout(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return QueueOperationResponse.create(this.client.receiveMessages(maxMessages, visibilityTimeout, timeout));
    }

    public QueueOperationResponse peekMessages(Exchange exchange) {
        if (exchange == null) {
            return QueueOperationResponse.create(this.client.peekMessages(this.configurationOptionsProxy.getMaxMessages(null), this.configurationOptionsProxy.getTimeout(null)));
        }
        Integer maxMessages = this.configurationOptionsProxy.getMaxMessages(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        return QueueOperationResponse.create(this.client.peekMessages(maxMessages, timeout));
    }

    public QueueOperationResponse updateMessage(Exchange exchange) {
        ObjectHelper.notNull((Object)exchange, (String)MISSING_EXCHANGE);
        String updatedText = (String)exchange.getIn().getBody(String.class);
        String messageId = this.configurationOptionsProxy.getMessageId(exchange);
        String popReceipt = this.configurationOptionsProxy.getPopReceipt(exchange);
        Duration visibilityTimeout = this.configurationOptionsProxy.getVisibilityTimeout(exchange);
        Duration timeout = this.configurationOptionsProxy.getTimeout(exchange);
        if (ObjectHelper.isEmpty((String)messageId)) {
            throw new IllegalArgumentException(String.format("Message ID must be specified in camel headers '%s' for updateMessage operation.", "CamelAzureStorageQueueMessageId"));
        }
        if (ObjectHelper.isEmpty((String)popReceipt)) {
            throw new IllegalArgumentException(String.format("Message Pop Receipt must be specified in camel headers '%s' for updateMessage operation.", "CamelAzureStorageQueuePopReceipt"));
        }
        if (ObjectHelper.isEmpty((Object)visibilityTimeout)) {
            throw new IllegalArgumentException(String.format("Visibility Timeout must be specified in camel headers '%s' for updateMessage operation.", "CamelAzureStorageQueueVisibilityTimeout"));
        }
        Response<UpdateMessageResult> response = this.client.updateMessage(messageId, popReceipt, updatedText, visibilityTimeout, timeout);
        QueueExchangeHeaders headers = new QueueExchangeHeaders().timeNextVisible(((UpdateMessageResult)response.getValue()).getTimeNextVisible()).popReceipt(((UpdateMessageResult)response.getValue()).getPopReceipt()).httpHeaders(response.getHeaders());
        return QueueOperationResponse.createWithEmptyBody(headers.toMap());
    }

    private QueueOperationResponse buildResponseWithEmptyBody(Response response) {
        return QueueOperationResponse.createWithEmptyBody(response);
    }
}

