/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.azure.blob.BlobServiceComponent;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class BlobServiceComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private BlobServiceConfiguration getOrCreateConfiguration(BlobServiceComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new BlobServiceConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        BlobServiceComponent target = (BlobServiceComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "azureblobclient": 
            case "azureBlobClient": {
                this.getOrCreateConfiguration(target).setAzureBlobClient((CloudBlob)BlobServiceComponentConfigurer.property((CamelContext)camelContext, CloudBlob.class, (Object)value));
                return true;
            }
            case "blobmetadata": 
            case "blobMetadata": {
                this.getOrCreateConfiguration(target).setBlobMetadata((Map)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "bloboffset": 
            case "blobOffset": {
                this.getOrCreateConfiguration(target).setBlobOffset((Long)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "blobprefix": 
            case "blobPrefix": {
                this.getOrCreateConfiguration(target).setBlobPrefix((String)BlobServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "blobtype": 
            case "blobType": {
                this.getOrCreateConfiguration(target).setBlobType((BlobType)((Object)BlobServiceComponentConfigurer.property((CamelContext)camelContext, BlobType.class, (Object)value)));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterRead((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                this.getOrCreateConfiguration(target).setCloseStreamAfterWrite((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((BlobServiceConfiguration)BlobServiceComponentConfigurer.property((CamelContext)camelContext, BlobServiceConfiguration.class, (Object)value));
                return true;
            }
            case "credentials": {
                this.getOrCreateConfiguration(target).setCredentials((StorageCredentials)BlobServiceComponentConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                this.getOrCreateConfiguration(target).setCredentialsAccountKey((String)BlobServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                this.getOrCreateConfiguration(target).setCredentialsAccountName((String)BlobServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "datalength": 
            case "dataLength": {
                this.getOrCreateConfiguration(target).setDataLength((Long)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "filedir": 
            case "fileDir": {
                this.getOrCreateConfiguration(target).setFileDir((String)BlobServiceComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((BlobServiceOperations)((Object)BlobServiceComponentConfigurer.property((CamelContext)camelContext, BlobServiceOperations.class, (Object)value)));
                return true;
            }
            case "publicforread": 
            case "publicForRead": {
                this.getOrCreateConfiguration(target).setPublicForRead((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "streamreadsize": 
            case "streamReadSize": {
                this.getOrCreateConfiguration(target).setStreamReadSize((Integer)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "streamwritesize": 
            case "streamWriteSize": {
                this.getOrCreateConfiguration(target).setStreamWriteSize((Integer)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "useflatlisting": 
            case "useFlatListing": {
                this.getOrCreateConfiguration(target).setUseFlatListing((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "validateclienturi": 
            case "validateClientURI": {
                this.getOrCreateConfiguration(target).setValidateClientURI((Boolean)BlobServiceComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "azureblobclient": 
            case "azureBlobClient": {
                return CloudBlob.class;
            }
            case "blobmetadata": 
            case "blobMetadata": {
                return Map.class;
            }
            case "bloboffset": 
            case "blobOffset": {
                return Long.class;
            }
            case "blobprefix": 
            case "blobPrefix": {
                return String.class;
            }
            case "blobtype": 
            case "blobType": {
                return BlobType.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return Boolean.TYPE;
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return BlobServiceConfiguration.class;
            }
            case "credentials": {
                return StorageCredentials.class;
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                return String.class;
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                return String.class;
            }
            case "datalength": 
            case "dataLength": {
                return Long.class;
            }
            case "filedir": 
            case "fileDir": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return BlobServiceOperations.class;
            }
            case "publicforread": 
            case "publicForRead": {
                return Boolean.TYPE;
            }
            case "streamreadsize": 
            case "streamReadSize": {
                return Integer.TYPE;
            }
            case "streamwritesize": 
            case "streamWriteSize": {
                return Integer.TYPE;
            }
            case "useflatlisting": 
            case "useFlatListing": {
                return Boolean.TYPE;
            }
            case "validateclienturi": 
            case "validateClientURI": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        BlobServiceComponent target = (BlobServiceComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "azureblobclient": 
            case "azureBlobClient": {
                return this.getOrCreateConfiguration(target).getAzureBlobClient();
            }
            case "blobmetadata": 
            case "blobMetadata": {
                return this.getOrCreateConfiguration(target).getBlobMetadata();
            }
            case "bloboffset": 
            case "blobOffset": {
                return this.getOrCreateConfiguration(target).getBlobOffset();
            }
            case "blobprefix": 
            case "blobPrefix": {
                return this.getOrCreateConfiguration(target).getBlobPrefix();
            }
            case "blobtype": 
            case "blobType": {
                return this.getOrCreateConfiguration(target).getBlobType();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "closestreamafterread": 
            case "closeStreamAfterRead": {
                return this.getOrCreateConfiguration(target).isCloseStreamAfterRead();
            }
            case "closestreamafterwrite": 
            case "closeStreamAfterWrite": {
                return this.getOrCreateConfiguration(target).isCloseStreamAfterWrite();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "credentials": {
                return this.getOrCreateConfiguration(target).getCredentials();
            }
            case "credentialsaccountkey": 
            case "credentialsAccountKey": {
                return this.getOrCreateConfiguration(target).getCredentialsAccountKey();
            }
            case "credentialsaccountname": 
            case "credentialsAccountName": {
                return this.getOrCreateConfiguration(target).getCredentialsAccountName();
            }
            case "datalength": 
            case "dataLength": {
                return this.getOrCreateConfiguration(target).getDataLength();
            }
            case "filedir": 
            case "fileDir": {
                return this.getOrCreateConfiguration(target).getFileDir();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "publicforread": 
            case "publicForRead": {
                return this.getOrCreateConfiguration(target).isPublicForRead();
            }
            case "streamreadsize": 
            case "streamReadSize": {
                return this.getOrCreateConfiguration(target).getStreamReadSize();
            }
            case "streamwritesize": 
            case "streamWriteSize": {
                return this.getOrCreateConfiguration(target).getStreamWriteSize();
            }
            case "useflatlisting": 
            case "useFlatListing": {
                return this.getOrCreateConfiguration(target).isUseFlatListing();
            }
            case "validateclienturi": 
            case "validateClientURI": {
                return this.getOrCreateConfiguration(target).isValidateClientURI();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "blobmetadata": 
            case "blobMetadata": {
                return String.class;
            }
        }
        return null;
    }
}

