/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProcessorFactoryResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(BeanProcessorFactoryResolver.class);
    private FactoryFinder factoryFinder;

    public BeanProcessorFactory resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("bean-processor-factory", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found BeanProxyFactory: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "bean-processor-factory"});
            }
            if (BeanProcessorFactory.class.isAssignableFrom(type)) {
                BeanProcessorFactory answer = (BeanProcessorFactory)context.getInjector().newInstance(type, false);
                LOG.debug("Detected and using BeanProcessorFactory: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a BeanProcessorFactory implementation. Found: " + type.getName());
        }
        LOG.debug("Cannot find BeanProcessorFactory. Make sure camel-bean is on the classpath.");
        return null;
    }

    private Class<?> findFactory(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }
}

