/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.impl.engine.EventDrivenConsumerRoute;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultRouteContext
implements RouteContext {
    private NamedNode route;
    private String routeId;
    private Route runtimeRoute;
    private Endpoint endpoint;
    private final List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private CamelContext camelContext;
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private ManagementInterceptStrategy managementInterceptStrategy;
    private boolean routeAdded;
    private Boolean trace;
    private Boolean debug;
    private Boolean messageHistory;
    private Boolean logMask;
    private Boolean logExhaustedMessageBody;
    private Boolean streamCache;
    private Boolean handleFault;
    private Long delay;
    private Boolean autoStartup = Boolean.TRUE;
    private List<RoutePolicy> routePolicyList = new ArrayList<RoutePolicy>();
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;
    private RouteError routeError;
    private RouteController routeController;
    private final Map<String, Processor> onCompletions = new HashMap<String, Processor>();
    private final Map<String, Processor> onExceptions = new HashMap<String, Processor>();
    private final List<CamelInternalProcessorAdvice<?>> advices = new ArrayList();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private ErrorHandlerFactory errorHandlerFactory;
    private Integer startupOrder;
    private Map<ErrorHandlerFactory, Set<NamedNode>> errorHandlers = new HashMap<ErrorHandlerFactory, Set<NamedNode>>();

    public DefaultRouteContext(CamelContext camelContext, NamedNode route, String routeId) {
        this.camelContext = camelContext;
        this.route = route;
        this.routeId = routeId;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public NamedNode getRoute() {
        return this.route;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public Route getRuntimeRoute() {
        return this.runtimeRoute;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Endpoint resolveEndpoint(String uri) {
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelContext, (String)uri);
    }

    public Endpoint resolveEndpoint(String uri, String ref) {
        Endpoint endpoint = null;
        if (uri != null && (endpoint = this.camelContext.getEndpoint(uri)) == null) {
            throw new NoSuchEndpointException(uri);
        }
        if (ref != null) {
            endpoint = this.lookup(ref, Endpoint.class);
            if (endpoint == null) {
                throw new NoSuchEndpointException("ref:" + ref, "check your camel registry with id " + ref);
            }
            if (!this.getCamelContext().equals(endpoint.getCamelContext())) {
                throw new NoSuchEndpointException("ref:" + ref, "make sure the endpoint has the same camel context as the route does.");
            }
            try {
                this.getCamelContext().addService((Object)endpoint);
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Either 'uri' or 'ref' must be specified on: " + this);
        }
        return endpoint;
    }

    public <T> T lookup(String name, Class<T> type) {
        return (T)this.getCamelContext().getRegistry().lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.getCamelContext().getRegistry().findByTypeWithName(type);
    }

    public <T> T mandatoryLookup(String name, Class<T> type) {
        return (T)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)name, type);
    }

    public Route commit() {
        if (!this.eventDrivenProcessors.isEmpty()) {
            CamelInternalProcessor.RouteLifecycleAdvice task2;
            Processor target = Pipeline.newInstance(this.getCamelContext(), this.eventDrivenProcessors);
            CamelInternalProcessor internal = new CamelInternalProcessor(target);
            internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(this));
            List<RoutePolicy> routePolicyList = this.getRoutePolicyList();
            if (routePolicyList != null && !routePolicyList.isEmpty()) {
                for (RoutePolicy policy : routePolicyList) {
                    if (this.camelContext.hasService((Object)policy)) continue;
                    try {
                        this.camelContext.addService((Object)policy);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                }
                internal.addAdvice(new CamelInternalProcessor.RoutePolicyAdvice(routePolicyList));
            }
            internal.addAdvice(new CamelInternalProcessor.RouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), this.routeId));
            if (this.managementInterceptStrategy != null) {
                internal.addAdvice(CamelInternalProcessor.wrap(this.managementInterceptStrategy.createProcessor("route")));
            }
            internal.addAdvice(new CamelInternalProcessor.RouteLifecycleAdvice());
            this.advices.forEach(internal::addAdvice);
            EventDrivenConsumerRoute edcr = new EventDrivenConsumerRoute((RouteContext)this, this.getEndpoint(), (Processor)internal);
            edcr.getProperties().putAll(this.properties);
            CamelInternalProcessor.RoutePolicyAdvice task = internal.getAdvice(CamelInternalProcessor.RoutePolicyAdvice.class);
            if (task != null) {
                task.setRoute(edcr);
            }
            if ((task2 = internal.getAdvice(CamelInternalProcessor.RouteLifecycleAdvice.class)) != null) {
                task2.setRoute(edcr);
            }
            if (routePolicyList != null && !routePolicyList.isEmpty()) {
                for (RoutePolicy policy : routePolicyList) {
                    policy.onInit((Route)edcr);
                }
            }
            this.runtimeRoute = edcr;
        }
        return this.runtimeRoute;
    }

    public void addEventDrivenProcessor(Processor processor) {
        this.eventDrivenProcessors.add(processor);
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    public void setManagementInterceptStrategy(ManagementInterceptStrategy interceptStrategy) {
        this.managementInterceptStrategy = interceptStrategy;
    }

    public ManagementInterceptStrategy getManagementInterceptStrategy() {
        return this.managementInterceptStrategy;
    }

    public boolean isRouteAdded() {
        return this.routeAdded;
    }

    public void setIsRouteAdded(boolean routeAdded) {
        this.routeAdded = routeAdded;
    }

    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    public Boolean isTracing() {
        if (this.trace != null) {
            return this.trace;
        }
        return this.getCamelContext().isTracing();
    }

    public void setDebugging(Boolean debugging) {
        this.debug = debugging;
    }

    public Boolean isDebugging() {
        if (this.debug != null) {
            return this.debug;
        }
        return this.getCamelContext().isDebugging();
    }

    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    public Boolean isMessageHistory() {
        if (this.messageHistory != null) {
            return this.messageHistory;
        }
        return this.getCamelContext().isMessageHistory();
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public Boolean isLogMask() {
        if (this.logMask != null) {
            return this.logMask;
        }
        return this.getCamelContext().isLogMask();
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public Boolean isLogExhaustedMessageBody() {
        if (this.logExhaustedMessageBody != null) {
            return this.logExhaustedMessageBody;
        }
        return this.getCamelContext().isLogExhaustedMessageBody();
    }

    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    public Boolean isStreamCaching() {
        if (this.streamCache != null) {
            return this.streamCache;
        }
        return this.getCamelContext().isStreamCaching();
    }

    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    public Boolean isHandleFault() {
        if (this.handleFault != null) {
            return this.handleFault;
        }
        return this.getCamelContext().isHandleFault();
    }

    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    public Long getDelayer() {
        if (this.delay != null) {
            return this.delay;
        }
        return this.getCamelContext().getDelayer();
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Boolean isAutoStartup() {
        if (this.autoStartup != null) {
            return this.autoStartup;
        }
        return true;
    }

    public void setStartupOrder(Integer startupOrder) {
        this.startupOrder = startupOrder;
    }

    public Integer getStartupOrder() {
        return this.startupOrder;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.getCamelContext().setAllowUseOriginalMessage(allowUseOriginalMessage);
    }

    public Boolean isAllowUseOriginalMessage() {
        return this.getCamelContext().isAllowUseOriginalMessage();
    }

    public ShutdownRoute getShutdownRoute() {
        if (this.shutdownRoute != null) {
            return this.shutdownRoute;
        }
        return this.getCamelContext().getShutdownRoute();
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        if (this.shutdownRunningTask != null) {
            return this.shutdownRunningTask;
        }
        return this.getCamelContext().getShutdownRunningTask();
    }

    public void setRoutePolicyList(List<RoutePolicy> routePolicyList) {
        this.routePolicyList = routePolicyList;
    }

    public List<RoutePolicy> getRoutePolicyList() {
        return this.routePolicyList;
    }

    public RouteError getLastError() {
        return this.routeError;
    }

    public void setLastError(RouteError routeError) {
        this.routeError = routeError;
    }

    public RouteController getRouteController() {
        return this.routeController;
    }

    public void setRouteController(RouteController routeController) {
        this.routeController = routeController;
    }

    public Processor getOnCompletion(String onCompletionId) {
        return this.onCompletions.get(onCompletionId);
    }

    public void setOnCompletion(String onCompletionId, Processor processor) {
        this.onCompletions.put(onCompletionId, processor);
    }

    public Processor getOnException(String onExceptionId) {
        return this.onExceptions.get(onExceptionId);
    }

    public void setOnException(String onExceptionId, Processor processor) {
        this.onExceptions.put(onExceptionId, processor);
    }

    public void addAdvice(CamelInternalProcessorAdvice<?> advice) {
        this.advices.add(advice);
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void addErrorHandler(ErrorHandlerFactory factory, NamedNode onException) {
        this.getErrorHandlers(factory).add(onException);
    }

    public Set<NamedNode> getErrorHandlers(ErrorHandlerFactory factory) {
        return this.errorHandlers.computeIfAbsent(factory, f -> new LinkedHashSet());
    }

    public void addErrorHandlerFactoryReference(ErrorHandlerFactory source, ErrorHandlerFactory target) {
        Set<NamedNode> previous;
        Set<NamedNode> list = this.getErrorHandlers(source);
        if (list != (previous = this.errorHandlers.put(target, list)) && ObjectHelper.isNotEmpty(previous) && ObjectHelper.isNotEmpty(list)) {
            throw new IllegalStateException("multiple references with different handlers");
        }
    }
}

