/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.impl.engine.DefaultHeadersMapFactory;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.HeadersMapFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersMapFactoryResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(HeadersMapFactoryResolver.class);
    private FactoryFinder factoryFinder;

    public HeadersMapFactory resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("headers-map-factory", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found HeadersMapFactory: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "headers-map-factory"});
            }
            if (HeadersMapFactory.class.isAssignableFrom(type)) {
                HeadersMapFactory answer = (HeadersMapFactory)context.getInjector().newInstance(type, false);
                LOG.info("Detected and using custom HeadersMapFactory: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a HeadersMapFactory implementation. Found: " + type.getName());
        }
        LOG.debug("Creating default HeadersMapFactory");
        return new DefaultHeadersMapFactory();
    }

    private Class<?> findFactory(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }
}

